<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 28/01/14
 * Time: 22:01
 */

namespace Sigza\AdminBundle\Controller;
use Sigza\CoreBundle\Entity as entities;
use Sigza\CoreBundle\Form as forms;
use Pagerfanta\Adapter\DoctrineORMAdapter;
use Pagerfanta\Pagerfanta;
use Pagerfanta\View\TwitterBootstrapView;
use Symfony\Component\HttpFoundation\Request;
use Sigza\AdminBundle\Controller\AdminCrudController;

class ChacraController extends AdminCrudController{

    function __construct()
    {
        $this->entityName = "Chacra";
        $this->notFoundMessage = "No se pudo encontrar la chacra solicitada";
        $this->sigle = "Chacra";
        $this->plural = "Chacras";
    }

    public function indexAction($page)
    {
        $productor = $this->getParam("_p");
        $queryBuilder = null;
        if($productor == null)
            $queryBuilder = $this->coreService()->CRUDlistarQuery($this->entityName);
        else
            $queryBuilder = $this->coreService()->chacrasPorProductor($productor);

        list($entities,$pagerHtml) = $this->paginator2($queryBuilder,$page, $productor);

        return $this->render($this->bundleName.":".$this->entityName.":index.html.twig", array(
            'entities' => $entities,
            'entityName' => $this->entityName,
            'pagerHtml' => $pagerHtml,
            '_p' => $productor != null ? $this->coreService()->CRUDBuscarPorId('Productor',$productor) : null ,
            'title'=>"Listado de ".$this->plural
        ));
    }

    public function newAction()
    {
        $productor = $this->getParam("_p");
        $entity = $this->buildEntity();
        $_p = null;
        if($productor != null)
            $_p = $this->coreService()->CRUDBuscarPorId('Productor',$productor);
        $form = $this->buildType($entity);
        return $this->render($this->bundleName.":".$this->entityName.":new.html.twig", array(
            'entity' => $entity,
            'form'   => $form->createView(),
            'entityName' => $this->entityName,
            'title'=>"Crear ".$this->sigle,
            'retorno'=>$this->getParam("retorno"),
            '_p'=>$_p,
            'bundleName'=>$this->bundleName
        ));
    }

    public function createAction(Request $request)
    {
        $productor = $this->getParam("_p");
        $entity = $this->buildEntity();
        $form = $this->buildType($entity);
        $form->submit($request);
        $retorno = $this->getParam("retorno");
        if ($form->isValid()) {
            if($productor)
               $entity->setProductor(  $this->coreService()->CRUDBuscarPorId("Productor",$productor)  );
            $this->save($entity);
            if($retorno == null || $retorno == ''){
                if($productor != '' && $productor != null)
                  return $this->redirect($this->generateUrl($this->entityName.'_show', array('id' => $entity->getId(),'_p'=>$productor)));
                return $this->redirect($this->generateUrl($this->entityName.'_show', array('id' => $entity->getId())));
            }

            $rs = str_getcsv($retorno,",");
            $r = $rs[ count($rs) - 1 ];
            $retorno = "";
            for($i = 0; $i < count($rs) - 1; $i++){
                if($i > 0)
                    $retorno.=',';
                $retorno.=$rs[$i];
            }


            return $this->redirect($this->generateUrl($r, array('id' => $entity->getId(),"retorno"=>$retorno)));
        }
        return $this->render($this->bundleName.":".$this->entityName.":new.html.twig", array(
            'entity' => $entity,
            'form'   => $form->createView(),
            'entityName' => $this->entityName,
            'title'=>"Crear ".$this->sigle,
            '_p'=>$this->coreService()->CRUDBuscarPorId('Productor',$productor),
            'retorno'=>$retorno
        ));
    }

    public function showAction($id)
    {
        $productor = $this->getParam("_p");
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        $showForm = $this->buildType($entity);
        $deleteForm = $this->createDeleteForm($id);
        return $this->render($this->bundleName.":".$this->entityName.":show.html.twig", array(
            'entity'      => $entity,
            'entityName' => $this->entityName,
            'showForm' => $showForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'title'=>"Mostrar ".$this->sigle,
            '_p' => $productor != null ? $this->coreService()->CRUDBuscarPorId('Productor',$productor) : null ,
            'bundleName'=>$this->bundleName));
    }


    public function editAction($id)
    {
        $productor = $this->getParam("_p");
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        $editForm = $this->buildType($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render($this->bundleName.":".$this->entityName.":edit.html.twig", array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'entityName' => $this->entityName,
            'title'=>"Editar ".$this->sigle,
            'retorno'=>$this->getParam("retorno"),
            '_p' => $productor != null ? $this->coreService()->CRUDBuscarPorId('Productor',$productor) : null ,
            'bundleName'=>$this->bundleName
        ));
    }

    public function updateAction(Request $request,$id)
    {
        $productor = $this->getParam("_p");
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->buildType($entity);
        $editForm->submit($request);
        $retorno = $this->getParam("retorno");

        if ($editForm->isValid()) {
            $this->save($entity);
            if($retorno == null || $retorno == ''){
                if($productor != '' && $productor != null)
                    return $this->redirect($this->generateUrl($this->entityName.'_edit', array('id' => $entity->getId(),'_p'=>$productor)));
                return $this->redirect($this->generateUrl($this->entityName.'_edit', array('id' => $entity->getId())));
            }

            $rs = str_getcsv($retorno,",");
            $r = $rs[ count($rs) - 1 ];
            $retorno = "";
            for($i = 0; $i < count($rs) - 1; $i++){
                if($i > 0)
                    $retorno.=',';
                $retorno.=$rs[$i];
            }


            return $this->redirect($this->generateUrl($r, array('id' => $entity->getId(),"retorno"=>$retorno)));
        }

        return $this->render($this->bundleName.":".$this->entityName.":edit.html.twig", array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'entityName' => $this->entityName,
            'title'=>"Editar ".$this->sigle,
            'bundleName'=>$this->bundleName,
            '_p'=>$this->coreService()->CRUDBuscarPorId('Productor',$productor),
            'retorno'=>$retorno
        ));
    }

    public function deleteAction(Request $request, $id)
    {
        $productor = $this->getParam("_p");
        $form = $this->createDeleteForm($id);
        $form->submit($request);
        if ($form->isValid()) {
            $entity = $this->buscarPorId($id);
            if (!$entity) {
                throw $this->createNotFoundException($this->notFoundMessage);
            }
            $this->coreService()->delete($entity,true);
        }
        if($productor == null)
          return $this->redirect($this->generateUrl($this->entityName,array()));
        return $this->redirect($this->generateUrl($this->entityName,array('_p'=>$productor)));
    }

    protected function paginator2($queryBuilder,$page,$productor){
        // Paginator
        $adapter = new DoctrineORMAdapter($queryBuilder);
        $pagerfanta = new Pagerfanta($adapter);
        //$pagerfanta->setMaxPerPage(3);
        $pagerfanta->setCurrentPage($page);
        $entities = $pagerfanta->getCurrentPageResults();

        // Paginator - route generator
        $me = $this;
        $entityName = $this->entityName;
        $routeGenerator = function($page) use ($me,$entityName, $productor)
        {
            if($productor != null)
                return $me->generateUrl($entityName, array('page' => $page, '_p'=>$productor));
            return $me->generateUrl($entityName, array('page' => $page));
        };

        // Paginator - view
        $view = new TwitterBootstrapView();
        $pagerHtml = $view->render($pagerfanta, $routeGenerator, array(
            'proximity' => 3,
            'prev_message' => 'Atras',
            'next_message' => 'Adelante',
        ));
        return array($entities,$pagerHtml);
    }
} 