<?php

namespace Sigza\AdminBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sigza\CoreBundle\Controller\CommonController;
use Sigza\CoreBundle\Entity\Registro;
use Sigza\CoreBundle\Entity\Resultados;
use Sigza\CoreBundle\Entity\Usuario;
use Sigza\CoreBundle\Form\UsuarioType;
use Symfony\Component\HttpFoundation\Response;

class DefaultController extends CommonController
{
    public function indexAction()
    {
        return $this->render('AdminBundle:Default:index.html.twig', array(
        ));
    }
    private function notEmpty($val){
        return $val != null && $val != '';
    }

    public function recalcularRemitosProductorAction(){

        if($this->isPost()){
            $registros = $this->getParam("registros");
            $registros = str_getcsv($registros,",");

            for($i = 0; $i < count($registros); $i++){
                $registro = $this->coreService()->buscarRegistroPorId($registros[$i]);
                $this->coreService()->actualizarResultados($registro);
            }
            return $this->redirect('actualizar_recalcular_remitos');
        }

        return $this->redirect('actualizar_recalcular_remitos');
    }


    public function actualizarRecalcularRemitosAction(){
        $parametros = array();
        $estadoremito = 0;
        $chacraTotal = 0;
        $netoTotal = 0;
        $data = array();
        $fi = null;
        $ff = null;
        $productor = null;
        $productores = $this->coreService()->CRUDlistar("Productor");
        if($this->isPost()){
            //Filtros no utilizados
            $filtros = array();
            $filtros["remito"] = null;
            $filtros["matricula"] = null ;
            $filtros["estado"] = 2 ;
            $filtros["remitoProductor"] = null;
            $filtros["variedad"] = null;
            $filtros["chacra"] = null;
            $filtros["empresa"] = null;

            //filtros utilizados
            $fi = $this->getParam("fi");
            $ff = $this->getParam("ff");
            $productores = $this->coreService()->CRUDlistar("Productor");

            $filtros["fi"] = $this->notEmpty($fi)  ? date_create_from_format("d/m/Y",$fi) : null ;
            $filtros["ff"] = $this->notEmpty($ff)  ? date_create_from_format("d/m/Y",$ff) : null ;
            $productor = null;
            $productor = $this->getParam("productor");
            $filtros["planta"] = null;
            $filtros["productor"] = $productor ? $productor : null;
            $page = $this->getParam("page");
            if(!$page)
                $page = 1;
            $queryBuilder = $this->coreService()->listarInfoProductorQuery($filtros);
            $totales = $this->coreService()->totales($filtros);
            $chacraTotal = number_format($totales[0], 2, '.', ',');
            $netoTotal =  number_format($totales[1], 2, '.', ',');
            $entities = $queryBuilder->getResult();
            //list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"productor_remitos_listar");

            $data = array();
            for($i =0; $i<count($entities);$i++){
                $dataRemito = array();
                /**
                 * @var Registro $r
                 */
                $r = $entities[$i];
                $cerrado = $r->getCerrado();

                if ($cerrado == null || $cerrado == false)
                    $estadoremito = -1;
                else
                    $estadoremito = 1;

                $dataRemito["id"]=$r->getId(); //Id en Registro
                $dataRemito["registro"]=$r;
                $dataRemito["remito"]=$r->getRemito();
                $dataRemito["estado"]=$estadoremito;
                $dataRemito["planta"]=$r->getPlanta()->getNombre();
                $dataRemito["fechaEntrada"]=$r->getFechaEntrada();
                if($r->getFechaSalida()== null)
                    $dataRemito["fechaSalida"]="";
                else
                    $dataRemito["fechaSalida"]=$r->getFechaSalida();

                $parametros = $this->coreService()->CRUDBuscarPorId("Parametros",$r->getId());
                if($parametros->getCerrado()){
                    $dataRemito["Cerrado"]= 1;
                }else{
                    $dataRemito["Cerrado"]= -1;
                }
                /**
                 * @var Resultados $resultados
                 */
                $resultados = $this->coreService()->CRUDBuscarPorId("Resultados",$r->getId());//resultados por registro

                if($resultados->getArrozChacra() == null){
                    $dataRemito["Chacra"]="-";
                }else{
                    $dataRemito["Chacra"]=number_format($resultados->getArrozChacra(), 2, '.', ',');
                }
                if($resultados->getArrozNeto() == null){

                    $dataRemito["Neto"]="-";
                }else{
                    $dataRemito["Neto"]=number_format($resultados->getArrozNeto(), 2, '.', ',');
                }
                array_push($data,$dataRemito);
        }
        }

        return $this->render('AdminBundle:Default:actualizarRecalcularRemitos.html.twig', array(
            "data"=>$data,
            "fi"=>$fi,
            "ff"=>$ff,
            "productores"=>$productores,
            "productor"=>$productor == null ? -1 : $productor,
            'chacraTotal'=>$chacraTotal,
            'netoTotal'=>$netoTotal,
        ));
    }
}
