<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Maikel
 * Date: 2/7/14
 * Time: 7:03 PM
 * To change this template use File | Settings | File Templates.
 */

namespace Sigza\AdminBundle\Controller;
use Sigza\AdminBundle\Controller\AdminCrudController;
use Symfony\Component\HttpFoundation\Request;

class EmpleadoController extends AdminCrudController{
    function __construct()
    {
        $this->entityName = "Empleado";
        $this->notFoundMessage = "No se pudo encontrar el empleado solicitado";
        $this->sigle = "Empleado";
        $this->plural = "Empleados";
    }
    
    public function updateAction(Request $request,$id)
    {
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->buildType($entity);
        $editForm->submit($request);
        $retorno = $this->getParam("retorno");

        if ($editForm->isValid()) {
            $this->save($entity);
            $usuario = $this->coreService()->buscarUsuario(1,$id);
            if($usuario) {
                $usuario->setPlanta($entity->getPlanta());
                $this->coreService()->save($usuario, true);
            }
            if($retorno == null || $retorno == '')
                return $this->redirect($this->generateUrl($this->entityName.'_edit', array('id' => $id)));

            $rs = str_getcsv($retorno,",");
            $r = $rs[ count($rs) - 1 ];
            $retorno = "";
            for($i = 0; $i < count($rs) - 1; $i++){
                if($i > 0)
                    $retorno.=',';
                $retorno.=$rs[$i];
            }


            return $this->redirect($this->generateUrl($r, array('id' => $entity->getId(),"retorno"=>$retorno)));
        }

        return $this->render($this->bundleName.":".$this->entityName.":edit.html.twig", array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'entityName' => $this->entityName,
            'title'=>"Editar ".$this->sigle,
            'bundleName'=>$this->bundleName,
            'retorno'=>$retorno
        ));
    }
}