<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 28/01/14
 * Time: 22:01
 */

namespace Sigza\AdminBundle\Controller;
use Symfony\Component\HttpFoundation\Request;
use Sigza\CoreBundle\Entity as enities;
use Sigza\CoreBundle\Entity as entities;
use Sigza\CoreBundle\Form as forms;
use Pagerfanta\Adapter\DoctrineORMAdapter;
use Pagerfanta\Pagerfanta;
use Pagerfanta\View\TwitterBootstrapView;
use Sigza\AdminBundle\Controller\AdminCrudController;

class UsuarioController extends AdminCrudController{

    function __construct()
    {
        $this->entityName = "Usuario";
        $this->notFoundMessage = "No se pudo encontrar el usuario solicitado";
        $this->sigle = "Usuario";
        $this->plural = "Usuarios";
    }

    public function indexAction($page)
    {
        $queryBuilder = $this->coreService()->CRUDlistarQuery($this->entityName);
        list($entities,$pagerHtml) = $this->paginator($queryBuilder,$page);

        for($i = 0; $i < count($entities); $i++){
            $tipo = $entities[$i]->getTipo();
            $ref = $entities[$i]->getReferencia();
            $e = $this->coreService()->CRUDBuscarPorId( $tipo == 1 ? "Empleado" : ($tipo == 2 ? "Productor" : null), $ref );
            $entities[$i]->setDetalles($e);
        }

        return $this->render($this->bundleName.":".$this->entityName.":index.html.twig", array(
            'entities' => $entities,
            'entityName' => $this->entityName,
            'pagerHtml' => $pagerHtml,
            'title'=>"Listado de ".$this->plural
        ));
    }

    public function createAction(Request $request)
    {
        $entity = $this->buildEntity();
        $form = $this->buildType($entity);
        $form->submit($request);
        $retorno = $this->getParam("retorno");
        if ($form->isValid()) {
            $factory = $this->get("security.encoder_factory");
            $encoder = $factory->getEncoder($entity);
            $entity->setPassword($encoder->encodePassword($entity->getPassword(), $entity->getSalt()));
            if($entity->getTipo()==1){
                $e = $this->coreService()->CRUDBuscarPorId( "Empleado", $entity->getReferencia() );
                $entity->setPlanta($e->getPlanta());
            }
            $this->save($entity);
            if($retorno == null || $retorno == '')
                return $this->redirect($this->generateUrl($this->entityName.'_show', array('id' => $entity->getId())));

            $rs = str_getcsv($retorno,",");
            $r = $rs[ count($rs) - 1 ];
            $retorno = "";
            for($i = 0; $i < count($rs) - 1; $i++){
                if($i > 0)
                    $retorno.=',';
                $retorno.=$rs[$i];
            }


            return $this->redirect($this->generateUrl($r, array('id' => $entity->getId(),"retorno"=>$retorno)));
        }

        $ref_ = $this->coreService()->CRUDBuscarPorId( ($entity->getTipo() == 1 ? "Empleado" : "Productor"),$entity->getReferencia()) ;
        $entity->setDetalles($ref_);

        return $this->render($this->bundleName.":".$this->entityName.":new.html.twig", array(
            'entity' => $entity,
            'form'   => $form->createView(),
            'entityName' => $this->entityName,
            'title'=>"Crear ".$this->sigle,
            'retorno'=>$retorno,
            'bundleName'=>$this->bundleName
        ));


    }

    public function passchangeAction($id)
    {
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        $editForm = $this->buildType($entity);
        $deleteForm = $this->createDeleteForm($id);
        $ref_ = null;
        if($entity->getTipo()){
        $ref_ = $this->coreService()->CRUDBuscarPorId( ($entity->getTipo() == 1 ? "Empleado" : "Productor"),$entity->getReferencia()) ;
        $entity->setDetalles($ref_);
        }

        return $this->render($this->bundleName.":".$this->entityName.":changepass.html.twig", array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'entityName' => $this->entityName,
            'title'=>"Cambiar contraseña ",
            'bundleName'=>$this->bundleName
        ));
    }

    public function passupdateAction(Request $request,$id)
    {
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->buildType($entity);
        $editForm->submit($request);

        if ($editForm->isValid()) {
            $factory = $this->get("security.encoder_factory");
            $encoder = $factory->getEncoder($entity);
            $entity->setPassword($encoder->encodePassword($entity->getPassword(), $entity->getSalt()));
            $this->save($entity);
            return $this->redirect($this->generateUrl($this->entityName));
        }

        return $this->render($this->bundleName.":".$this->entityName.":changepass.html.twig", array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'entityName' => $this->entityName,
            'title'=>"Cambiar contraseña ",
            'bundleName'=>$this->bundleName
        ));
    }

    public function roleschangeAction($id)
    {
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        if($entity->getUsuario() == 'root')
            return $this->redirect( $this->generateUrl($this->entityName) );

        $roles = $this->coreService()->CRUDlistar("Rol");
        return $this->render($this->bundleName.":".$this->entityName.":changeroles.html.twig", array(
            'entity'      => $entity,
            'entityName' => $this->entityName,
            'title'=>"Actualizar roles ",
            'roles'=>$roles,
            'bundleName'=>$this->bundleName
        ));
    }

    public function rolesupdateAction(Request $request,$id)
    {


        $roles_ = $request->get("roles_hidden");
        $roles_ = str_getcsv($roles_,",");



        /**
         * @var entities\Usuario $entity
         */
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        if($entity->getUsuario() == 'root')
            return $this->redirect( $this->generateUrl($this->entityName) );


        $roles = array();
        for($i = 0; $i < count($roles_); $i++){
            array_push( $roles, $this->coreService()->CRUDBuscarPorId("Rol",$roles_[$i]) );
        }

        $entity->setRoles($roles);
        $rl = $entity->getRoles();
        for($i = 0; $i < count($rl); $i++){
            $this->get("logger")->info(" >>>>>>>>>>>>>ROL SET>>>>>>>>".$rl[$i]);
        }

        $this->save($entity);
        $this->get("logger")->info(" DESPUES >>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        $rl = $entity->getRoles();
        for($i = 0; $i < count($rl); $i++){
            $this->get("logger")->info(" >>>>>>>>>>>>>ROL SET>>>>>>>>".$rl[$i]);
        }

        return $this->redirect($this->generateUrl($this->entityName));
    }

    private function paginator($queryBuilder,$page){
        // Paginator
        $adapter = new DoctrineORMAdapter($queryBuilder);
        $pagerfanta = new Pagerfanta($adapter);
        //$pagerfanta->setMaxPerPage(1);
        $pagerfanta->setCurrentPage($page);
        $entities = $pagerfanta->getCurrentPageResults();

        // Paginator - route generator
        $me = $this;
        $entityName = $this->entityName;
        $routeGenerator = function($page) use ($me,$entityName)
        {
            return $me->generateUrl($entityName, array('page' => $page));
        };

        // Paginator - view
        $view = new TwitterBootstrapView();
        $pagerHtml = $view->render($pagerfanta, $routeGenerator, array(
            'proximity' => 3,
            'prev_message' => 'Atras',
            'next_message' => 'Adelante',
        ));
        return array($entities,$pagerHtml);
    }

    public function deshabilitarAction($id){
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        if($entity->getUsuario() == 'root')
            return $this->redirect( $this->generateUrl($this->entityName) );
        $est = $entity->getDisabled();
        $entity->setDisabled(!$est);
        $this->save($entity);
        return $this->redirect( $this->generateUrl($this->entityName) );
    }

    public function new2Action($id, $tipo, $retorno)
    {

        if($tipo != 1 && $tipo != 2)
            return $this->redirect( $this->generateUrl($retorno) );

        $ref_ = $this->coreService()->CRUDBuscarPorId( ($tipo == 1 ? "Empleado" : "Productor"),$id  ) ;
        if(!$ref_)
            return $this->redirect( $this->generateUrl($retorno) );

        $u_ = $this->coreService()->buscarUsuario($tipo, $id);
        if($u_)
            return $this->redirect( $this->generateUrl($this->entityName."_passchange", array("id"=>$u_->getId(),"retorno"=>$retorno)));

        $entity = $this->buildEntity();
        $entity->setReferencia($id);
        $entity->setTipo($tipo);
        $entity->setDetalles($ref_);
        $form = $this->buildType($entity);

        return $this->render($this->bundleName.":".$this->entityName.":new.html.twig", array(
            'entity' => $entity,
            'form'   => $form->createView(),
            'entityName' => $this->entityName,
            'title'=>"Crear ".$this->sigle,
            'retorno'=>$retorno,
            'bundleName'=>$this->bundleName
        ));
    }
    public function edit2Action($id,$retorno)
    {
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        if($entity->getUsuario() == 'root')
            return $this->redirect( $this->generateUrl($this->entityName) );

        $ref_ = $this->coreService()->CRUDBuscarPorId( ($entity->getTipo() == 1 ? "Empleado" : "Productor"), $entity->getReferencia()  ) ;
        $entity->setDetalles($ref_);
        $editForm = $this->buildType($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render($this->bundleName.":".$this->entityName.":edit.html.twig", array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'entityName' => $this->entityName,
            'title'=>"Editar ".$this->sigle,
            'retorno'=>$retorno,
            'bundleName'=>$this->bundleName
        ));
    }

    public function updateAction(Request $request,$id)
    {
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        if($entity->getUsuario() == 'root')
            return $this->redirect( $this->generateUrl($this->entityName) );
        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->buildType($entity);
        $editForm->submit($request);
        $retorno = $this->getParam("retorno");

        if ($editForm->isValid()) {
            $this->save($entity);
            if($retorno == null || $retorno == '')
                return $this->redirect($this->generateUrl($this->entityName.'_edit', array('id' => $id)));

            $rs = str_getcsv($retorno,",");
            $r = $rs[ count($rs) - 1 ];
            $retorno = "";
            for($i = 0; $i < count($rs) - 1; $i++){
                if($i > 0)
                    $retorno.=',';
                $retorno.=$rs[$i];
            }


            return $this->redirect($this->generateUrl($r, array('id' => $entity->getId(),"retorno"=>$retorno)));
        }

        $ref_ = $this->coreService()->CRUDBuscarPorId( ($entity->getTipo() == 1 ? "Empleado" : "Productor"),$entity->getReferencia()) ;
        $entity->setDetalles($ref_);

        return $this->render($this->bundleName.":".$this->entityName.":edit.html.twig", array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'entityName' => $this->entityName,
            'title'=>"Editar ".$this->sigle,
            'bundleName'=>$this->bundleName,
            'retorno'=>$retorno
        ));
    }

    /*
*/


 }