<?php
/**
 * Created by JetBrains PhpStorm.
 * User: maikel
 * Date: 31/10/13
 * Time: 19:48
 * To change this template use File | Settings | File Templates.
 */

namespace Sigza\AdminBundle\Form;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class BaseType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('humedad','decimal_type',array('label'=>'Humedad','max_length'=>45))
            ->add('verde','decimal_type',array('label'=>'Verde','max_length'=>45))
            ->add('basura','decimal_type',array('label'=>'Basura','max_length'=>45))
            ->add('quebrado','decimal_type',array('label'=>'Quebrados','max_length'=>45,'required'=>false))
            ->add('baseBlanco','decimal_type',array('label'=>'Base Blanco','max_length'=>45))
            ->add('baseCargo','decimal_type',array('label'=>'Base Cargo','max_length'=>45,'required'=>false))
            ->add('yeso','decimal_type',array('label'=>'Yeso','max_length'=>45))
            ->add('rojo','decimal_type',array('label'=>'Rojo','max_length'=>45))
            ->add('mancha','decimal_type',array('label'=>'Mancha','max_length'=>45))
            ->add('servicioSecado','decimal_type',array('label'=>'Servicio Secado','max_length'=>45))
            ->add('productor','entity',array('required'=>false,'label'=>'Productor','class' => 'CoreBundle:Productor','property' => 'nombre'))

        ;
    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Sigza\CoreBundle\Entity\Base'
        ));
    }

    public function getName()
    {
        return 'base';
    }
}