<?php

namespace Sigza\BalanzaBundle\Controller;

use Sigza\CoreBundle\Controller\CommonController;
use Sigza\CoreBundle\Entity\Camion;
use Sigza\CoreBundle\Entity\Parametros;
use Sigza\CoreBundle\Entity\Registro;
use Sigza\CoreBundle\Entity\Resultados;
use Sigza\CoreBundle\Form\RegistroType;


class DefaultController extends CommonController
{
    public function defaultAction()
    {

        return $this->render('BalanzaBundle:Default:index.html.twig');
    }

    public function chacrasProductorAction(){
        $id = $this->getParam("id");
        $chacras = "[";
        if($id){
          $chs = $this->coreService()->chacrasPorProductor($id)->getQuery()->getResult();
            for($i = 0; $i < count($chs); $i++){
                if($i > 0)
                    $this->putJSONString($chacras,",");
                $this->putJSONString($chacras,"{");
                $this->putJSONStringProp($chacras,"id",$chs[$i]->getId(),true);
                $this->putJSONStringProp($chacras,"nombre",$chs[$i]->getNombre(),false);
                $this->putJSONString($chacras,"}");
            }
        }
        $this->putJSONString($chacras,"]");
        return $this->responseJSON("{\"chacras\":".$chacras."}");
    }



    public function buscarMatriculaAction()
    {
        $usuario = $this->getUser()->getUsername();
        if ($usuario == "root"){
            return $this->redirect($this->generateUrl('core_home'));

        }
        $matricula = $this->getParam("matricula");
        $entities = array();
        $registro = array();
        $estados = array();
        $plantas = array();
        $pagerHtml = null;
        if($this->isPost()){
            $page = $this->getParam("page");
            if(!$page)
                $page = 1;
            $matricula = $this->getParam("matricula");
            $queryBuilder = $this->coreService()->buscarCamionesPorMatriculaQuery($matricula);
            list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"balanza_buscar_camion");
            for($i = 0;$i < count($entities); $i++){
                $e = 0;// fuera de la planta
                $r = $this->coreService()->remitoAbierto($entities[$i]->getMatricula());
                if($r != null){
                    $e = 1; // dentro de la planta
                    if($r->getHumedad() == null){
                        $e = 2; // dentro de la planta y sin humedad
                    }
                    $plantas[$entities[$i]->getMatricula()] = $r->getPlanta();
                    $registro[$entities[$i]->getMatricula()] = $r->getUsuario();
                }
                $estados[$entities[$i]->getMatricula()] = $e;

            }
        }
        else{
            $page = $this->getParam("page");
            if(!$page)
                $page = 1;

            $queryBuilder = $this->coreService()->buscarCamionesPorMatriculaQuery(null);
            list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"balanza_buscar_camion");
            for($i = 0;$i < count($entities); $i++){
                $e = 0;// fuera de la planta
                $r = $this->coreService()->remitoAbierto($entities[$i]->getMatricula());
                if($r != null){
                    $e = 1; // dentro de la planta
                    if($r->getHumedad() == null){
                        $e = 2; // dentro de la planta y sin humedad
                    }
                    $plantas[$entities[$i]->getMatricula()] = $r->getPlanta();
                    $registro[$entities[$i]->getMatricula()] = $r->getUsuario();
                }
                $estados[$entities[$i]->getMatricula()] = $e;

            }
        }

        return $this->render('BalanzaBundle:Default:buscarMatricula.html.twig', array(
            "matricula"=>$matricula,
            "plantas" =>$plantas,
            "registro"=>$registro,
            "camiones"=>$entities,
            "estados"=>$estados,
            'pagerHtml' => $pagerHtml,
        ));
    }

    public function buscarMatriculaMovilAction()
    {
        $matricula = null;
        $camiones = array();
        $estados = array();

        if($this->isPost()){
            $matricula = $this->getParam("matricula");
            $planta = $this->getUser()->getPlanta();
            $camiones = $this->coreService()->buscarCamionesPorMatricula($matricula);
            for($i = 0;$i < count($camiones); $i++){
                $e = 0;// fuera de la planta
                $r = $this->coreService()->remitoAbierto($camiones[$i]->getMatricula());
                if($r != null){
                    $e = 1; // dentro de la planta
                    if($r->getHumedad() == null){
                        $e = 2; // dentro de la planta y sin humedad
                    }
                }
                $estados[$camiones[$i]->getMatricula()] = $e;
            }
        }
        return $this->render('BalanzaBundle:Default:buscarMatriculaMovil.html.twig', array(
            "matricula"=>$matricula,
            "camiones"=>$camiones,
            "estados"=>$estados
        ));
    }

    public function indexAction()
    {
        /**
         * @var Registro $registro
         */
        $registro = null;
        $camion = $this->getParam("camion");
        $form = null;
        $e = $this->getParam("e");
        $cont = $this->getParam("cont");
        $remito = null;
        $usuarioLogueadoId = $this->getUser()->getId();

        if($this->isGet()){
        $remito = $this->getParam("remito");

        if($remito || $e != 0){
            if($remito)
               $registro = $this->coreService()->buscarRegistroPorRemito($remito);
            else
                $registro = $this->coreService()->remitoAbierto(  $camion  );
        }else{
            $registro = new Registro();
            $camion = $this->coreService()->buscarCamionPorMatricula($camion);
            $registro->setCamion($camion);

        }
        if(!$registro->getId()){
            $registro->setFechaEntrada(new \DateTime("now"));
            $registro->setHoraEntrada(new \DateTime("now"));
        }
        if(!$registro->getFechaSalida()){
            $registro->setFechaSalida(new \DateTime("now"));
            }
        if(!$registro->getHoraSalida()){
            $registro->setHoraSalida(new \DateTime("now"));
            }
            $form = $this->createForm(new RegistroType(),$registro);
        }else{
            $id = $this->getParam("id");
            $registro = ($id != null && $id != '') ? $this->coreService()->buscarRegistroPorId($id):new Registro();

            $form = $this->createForm(new RegistroType(),$registro);
            $form->submit($this->getRequest());
            if($registro->getCamion() == null){
                $registro->setCamion($this->coreService()->buscarCamionPorMatricula($camion));
            }
            if($form->isValid()){
                $user = $this->getUser();
                $planta = $user->getPlanta();
                $registro->setPlanta($planta);
                $registro->setUsuario($usuarioLogueadoId);

                $this->coreService()->save($registro,true);
                if(!$id){
                    $p = new Parametros();
                    $p->setId($registro);
                    $this->coreService()->save($p,false);


                    $r = new Resultados();
                    $r->setId($registro);
                    $this->coreService()->save($r,false);
                    $this->coreService()->flush();
                }else{
                    if($this->coreService()->remitoCerrado($registro)){
                        $this->coreService()->actualizarResultados($registro);
                        if($registro->getProductor()->getNotificacionRemitoCerrado())
                            $this->get('sigza.mailer')->sendMail(array('subject' => 'Remito cerrado', 'to' =>
                            $registro->getProductor()->getEmail(), 'body' => $this->productorEmailTotales($registro)));
                    }else{
                        if($registro->getFechaSalida()){
                            $this->coreService()->actualizarChacraResultados($registro);
                            if($registro->getProductor()->getNotificacionBalanzaCerrada())
                            $this->get('sigza.mailer')->sendMail(array('subject' => 'Remito cerrado en balanza', 'to' =>
                            $registro->getProductor()->getEmail(), 'body' => $this->productorEmailRemito($registro)));
                        }
                    }
                }

                if($cont == null)
                 return $this->redirect($this->generateUrl('balanza_buscar_registro'));
                else{
                    if($cont == 0)
                        $e = 2;
                    else
                        $e = 1;
                    $form = $this->createForm(new RegistroType(),$registro);
                }
            }
        }
        return $this->render('BalanzaBundle:Default:registro.html.twig', array(
            "form" => $form->createView(),
            "id" => $registro->getId(),
            "e"=>$e,
            "registro"=>$registro
        ));
    }


    public function actualizarAction($id){
        $registro = $this->coreService()->buscarRegistroPorId($id);
        $matricula = $registro->getCamion()->getMatricula();
        if (!$registro) {
            throw $this->createNotFoundException('No se encontró este registro.');
        }
        $form = $this->createForm(new RegistroType(),$registro);
        if($this->isPost()){
        $form->submit($this->getRequest());
        if($form->isValid()){
            $this->coreService()->save($registro,true);
            $this->coreService()->flush();
            if($this->coreService()->remitoCerrado($registro)){
                $this->coreService()->actualizarResultados($registro);
                if($registro->getProductor()->getNotificacionRemitoCerrado())
                    $this->get('sigza.mailer')->sendMail(array('subject' => 'Actualización del remito', 'to' =>
                    $registro->getProductor()->getEmail(), 'body' => $this->productorEmailTotales($registro)));
            }else{
                if($registro->getFechaSalida()){
                    $this->coreService()->actualizarChacraResultados($registro);
                    if($registro->getProductor()->getNotificacionBalanzaCerrada())
                        $this->get('sigza.mailer')->sendMail(array('subject' => 'Actualización del remito', 'to' =>
                        $registro->getProductor()->getEmail(), 'body' => $this->productorEmailRemito($registro)));
                }
            }
            return $this->redirect($this->generateUrl('balanza_buscar_registro'));
        }
        }
        return $this->render('BalanzaBundle:Default:editarRegistro.html.twig', array(
            "form" => $form->createView(),
            "registro"=>$registro,
            "matricula" => $matricula
        ));
    }

    public function buscarRemitoAction()
    {
        $remito = null;
        $entities = array();
        $estados = array();
        $pagerHtml = null;
        $planta = $this->getUser()->getPlanta();

        if($this->isPost()){
            $page = $this->getParam("page");
            if(!$page)
                $page = 1;
            $remito = $this->getParam("remito");

            $queryBuilder = $this->coreService()->buscarRegistrosPorRemitoQuery($remito,$planta);
            list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"balanza_buscar_remito");
            for($i = 0;$i < count($entities); $i++){
                $e = 0;// abierto
                $r = $entities[$i];
                if($r->getHumedad() == null){
                    $e = 2; //  sin humedad
                }else
                    if($r->getFechaSalida() == null)
                        $e = 1; // cerrar registro
                    else
                        $e = 3; // cerrado
                $estados[$r->getRemito()] = $e;
            }
        }
        else{
            $page = $this->getParam("page");
            if(!$page)
                $page = 1;
            $remito = $this->getParam("remito");

            $queryBuilder = $this->coreService()->listarRegistrosPorRemitosOrdenadosPorFecha($planta);
            list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"balanza_buscar_remito");
            for($i = 0;$i < count($entities); $i++){
                $e = 0;// abierto
                $r = $entities[$i];
                if($r->getHumedad() == null){
                    $e = 2; //  sin humedad
                }else
                    if($r->getFechaSalida() == null)
                        $e = 1; // cerrar registro
                    else
                        $e = 3; // cerrado
                $estados[$r->getRemito()] = $e;
            }
        }


        return $this->render('BalanzaBundle:Default:buscarRemito.html.twig', array(
            "remito"    => $remito,
            "registros" => $entities,
            "estados"   => $estados,
            'pagerHtml' => $pagerHtml,
        ));
    }


    public function buscarRemitoMovilAction()
    {
        $remito = null;
        $registros = array();
        $estados = array();

        if($this->isPost()){
            $remito = $this->getParam("remito");
            $registros = $this->coreService()->buscarRegistrosPorRemitosAbiertos($remito);
            for($i = 0;$i < count($registros); $i++){
                $e = 0;// abierto
                $r = $registros[$i];
                if($r->getHumedad() == null){
                    $e = 2; //  sin humedad
                }else
                    if($r->getFechaSalida() == null)
                        $e = 1; // cerrar registro
                    else
                        $e = 3; // cerrado



                $estados[$r->getRemito()] = $e;
            }
        }


        return $this->render('BalanzaBundle:Default:buscarRemitoMovil.html.twig', array(
            "remito"    => $remito,
            "registros" => $registros,
            "estados"   => $estados
        ));
    }


    public function buscarRegistroAction()
    {
        $remito = null;
        $entities = array();
        $estados = array();
        $pagerHtml = null;
        $planta = $this->getUser()->getPlanta();

        if($this->isPost()){
            $page = $this->getParam("page");
            if(!$page)
                $page = 1;
            $remito = $this->getParam("remito");

            $queryBuilder = $this->coreService()->buscarRegistrosPorRemitoQuery($remito,$planta);
            list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"balanza_buscar_remito");
            for($i = 0;$i < count($entities); $i++){
                $e = 0;// abierto
                $r = $entities[$i];
                if($r->getHumedad() == null){
                    $e = 2; //  sin humedad
                }else
                    if($r->getFechaSalida() == null)
                        $e = 1; // cerrar registro
                    else
                        $e = 3; // cerrado
                $estados[$r->getRemito()] = $e;
            }
        }
        else{
            $page = $this->getParam("page");
            if(!$page)
                $page = 1;
            $remito = $this->getParam("remito");

            $queryBuilder = $this->coreService()->listarRegistrosPorRemitosOrdenadosPorFecha($planta);
            list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"balanza_buscar_remito");
            for($i = 0;$i < count($entities); $i++){
                $e = 0;// abierto
                $r = $entities[$i];
                if($r->getHumedad() == null){
                    $e = 2; //  sin humedad
                }else
                    if($r->getFechaSalida() == null)
                        $e = 1; // cerrar registro
                    else
                        $e = 3; // cerrado
                $estados[$r->getRemito()] = $e;
            }
        }


        return $this->render('BalanzaBundle:Default:buscarRegistro.html.twig', array(
            "remito"    => $remito,
            "registros" => $entities,
            "estados"   => $estados,
            'pagerHtml' => $pagerHtml,
        ));
    }

}
