<?php
/**
 * Created by JetBrains PhpStorm.
 * User: maikel
 * Date: 30/10/13
 * Time: 16:06
 * To change this template use File | Settings | File Templates.
 */

namespace Sigza\CoreBundle\Controller;
use Sigza\CoreBundle\Entity as entities;
use Sigza\CoreBundle\Form as forms;
use Pagerfanta\Adapter\DoctrineORMAdapter;
use Pagerfanta\Pagerfanta;
use Pagerfanta\View\TwitterBootstrapView;
use Symfony\Component\HttpFoundation\Request;

class CommonCRUDController extends CommonController{

    protected $entityName = "Entity";
    protected $notFoundMessage = "No es posible encontrar la entidad";
    protected $forms = "Sigza\\CoreBundle\\Form\\";
    protected $entities = "Sigza\\CoreBundle\\Entity\\";
    protected $bundleName = "CoreBundle";
    protected $sigle = "Entity";
    protected $plural = "Entities";

    public function indexAction($page)
    {
        $queryBuilder = $this->coreService()->CRUDlistarQuery($this->entityName);
        list($entities,$pagerHtml) = $this->paginator($queryBuilder,$page);

        return $this->render($this->bundleName.":".$this->entityName.":index.html.twig", array(
            'entities' => $entities,
            'entityName' => $this->entityName,
            'pagerHtml' => $pagerHtml,
            'title'=>"Listado de ".$this->plural,
            'bundleName'=>$this->bundleName
        ));
    }

    public function newAction()
    {
        $entity = $this->buildEntity();
        $form = $this->buildType($entity);
        return $this->render($this->bundleName.":".$this->entityName.":new.html.twig", array(
            'entity' => $entity,
            'form'   => $form->createView(),
            'entityName' => $this->entityName,
            'title'=>"Crear ".$this->sigle,
            'retorno'=>$this->getParam("retorno"),
            'bundleName'=>$this->bundleName
        ));
    }

    public function createAction(Request $request)
    {
        $entity = $this->buildEntity();
        $form = $this->buildType($entity);
        $form->submit($request);
        $retorno = $this->getParam("retorno");
        if ($form->isValid()) {
            $this->save($entity);
            if($retorno == null || $retorno == '')
             return $this->redirect($this->generateUrl($this->entityName.'_show', array('id' => $entity->getId())));

            $rs = str_getcsv($retorno,",");
            $r = $rs[ count($rs) - 1 ];
            $retorno = "";
            for($i = 0; $i < count($rs) - 1; $i++){
                if($i > 0)
                    $retorno.=',';
                $retorno.=$rs[$i];
            }


            return $this->redirect($this->generateUrl($r, array('id' => $entity->getId(),"retorno"=>$retorno)));
        }
        return $this->render($this->bundleName.":".$this->entityName.":new.html.twig", array(
            'entity' => $entity,
            'form'   => $form->createView(),
            'entityName' => $this->entityName,
            'title'=>"Crear ".$this->sigle,
            'retorno'=>$retorno,
                'bundleName'=>$this->bundleName
        ));
    }

    public function showAction($id)
    {
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        $showForm = $this->buildType($entity);
        $deleteForm = $this->createDeleteForm($id);
        return $this->render($this->bundleName.":".$this->entityName.":show.html.twig", array(
            'entity'      => $entity,
            'entityName' => $this->entityName,
            'showForm' => $showForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'title'=>"Mostrar ".$this->sigle,
            'retorno'=>null,
            'bundleName'=>$this->bundleName));
    }

    public function editAction($id)
    {
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        $editForm = $this->buildType($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render($this->bundleName.":".$this->entityName.":edit.html.twig", array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'entityName' => $this->entityName,
            'title'=>"Editar ".$this->sigle,
            'retorno'=>$this->getParam("retorno"),
            'bundleName'=>$this->bundleName
        ));
    }

    public function updateAction(Request $request,$id)
    {
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->buildType($entity);
        $editForm->submit($request);
        $retorno = $this->getParam("retorno");

        if ($editForm->isValid()) {
            $this->save($entity);
            if($retorno == null || $retorno == '')
                return $this->redirect($this->generateUrl($this->entityName.'_edit', array('id' => $id)));

            $rs = str_getcsv($retorno,",");
            $r = $rs[ count($rs) - 1 ];
            $retorno = "";
            for($i = 0; $i < count($rs) - 1; $i++){
                if($i > 0)
                    $retorno.=',';
                $retorno.=$rs[$i];
            }


            return $this->redirect($this->generateUrl($r, array('id' => $entity->getId(),"retorno"=>$retorno)));
        }

        return $this->render($this->bundleName.":".$this->entityName.":edit.html.twig", array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'entityName' => $this->entityName,
            'title'=>"Editar ".$this->sigle,
            'bundleName'=>$this->bundleName,
            'retorno'=>$retorno
        ));
    }

    public function deleteAction(Request $request, $id)
    {
        $form = $this->createDeleteForm($id);
        $form->submit($request);
        if ($form->isValid()) {
            $entity = $this->buscarPorId($id);
            if (!$entity) {
                throw $this->createNotFoundException($this->notFoundMessage);
            }
            $this->coreService()->delete($entity,true);
        }
        return $this->redirect($this->generateUrl($this->entityName,array()));
    }

    protected  function buildEntity(){
        $name = $this->entities.$this->entityName;
        return new $name();
    }

    protected function buildType($entity){
        $typeName = $this->forms.$this->entityName.'Type';
        return $this->createForm(new $typeName(), $entity);
    }

    protected function buscarPorId($id){
        return $this->coreService()->CRUDBuscarPorId($this->entityName,$id);
    }

    protected function save($entity){
        $this->coreService()->save($entity,true);
    }

    private function paginator($queryBuilder,$page){
        // Paginator
        $adapter = new DoctrineORMAdapter($queryBuilder);
        $pagerfanta = new Pagerfanta($adapter);
       // $pagerfanta->setMaxPerPage(1);
        $pagerfanta->setCurrentPage($page);
        $entities = $pagerfanta->getCurrentPageResults();

        // Paginator - route generator
        $me = $this;
        $entityName = $this->entityName;
        $routeGenerator = function($page) use ($me,$entityName)
        {
            return $me->generateUrl($entityName, array('page' => $page));
        };

        // Paginator - view
        $view = new TwitterBootstrapView();
        $pagerHtml = $view->render($pagerfanta, $routeGenerator, array(
            'proximity' => 3,
            'prev_message' => 'Atras',
            'next_message' => 'Adelante',
        ));
        return array($entities,$pagerHtml);
    }


}