<?php
namespace Sigza\CoreBundle\Controller;

use Sigza\CoreBundle\Service\CoreService;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;
use Pagerfanta\Adapter\DoctrineORMAdapter;
use Pagerfanta\Pagerfanta;
use Pagerfanta\View\TwitterBootstrapView;
use Symfony\Component\HttpFoundation\Request;
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of CommonController
 * Clase de utilidades comunes a los controladores
 *
 * @author Maikel Pérez Martínez <kalafyan@gmail.com>
 */
abstract class CommonController extends Controller{
    //put your code here

    /** Obtener un parametro del request dada su clave
     * @param $key
     * @return mixed|null
     */
    public function getParam($key){
        return $this->getRequest()->get($key);
    }

    /** Verifica que el metodo utilizado sea post
     * @return bool
     */
    public function isPost(){
        return $this->getRequest()->isMethod('POST');
    }

    /** Verifica que el metodo utilizado sea get
     * @return bool
     */
    public function isGet(){
        return $this->getRequest()->isMethod('GET');
    }

    /** Devuelve un Response en formato JSON
     * @param $jsonData
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function responseJSON($jsonData){

        $response = new Response();
        $response->headers->set('Content-Type', 'application/json');
        $response->setStatusCode(200);
        $response->setContent($jsonData);
        return $response;
    }

    /** Agrega una propiedad en forma JSON a la cadena output, seguida o no de una coma
     * @param null $output
     * @param $propName
     * @param null $propValue
     * @param $siguiente
     * @return null|string
     */
    public function putJSONStringProp(&$output = null, $propName, $propValue = null, $siguiente){
        if($output == null)
            $output = '';
        $output = $output." \"".$propName."\":  \"" .($propValue == null ? '' : $propValue). "\" ";
        if($siguiente)
            $output = $output.", ";
        return $output;
    }

    /** Contatena una cadena al JSON output
     * @param null $output
     * @param null $string
     * @return null|string
     */
    public function putJSONString(&$output = null, $string = null){
        if($output == null)
            $output = '';
        $output = $output." ".($string == null ? '' : $string)." ";
        return $output;
    }




    public function getEncoderFactory(){
        return $this->get('security.encoder_factory');
    }

    private $service;



    /**
     * Creates a form to delete a Persona entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    protected  function createDeleteForm($id)
    {
        return $this->createFormBuilder(array('id' => $id))
            ->add('id', 'hidden')
            ->getForm()
            ;
    }

    /**
     * @var CoreService
     */
    private $_service;

    /**
     * @return CoreService
     */
    protected  function coreService(){
        if($this->_service == null)
            $this->_service = $this->get("sigza.coreService");
        return $this->_service;
    }


    protected  function paginatorRuter($queryBuilder,$page,$ruter){
        // Paginator
        $adapter = new DoctrineORMAdapter($queryBuilder);
        $pagerfanta = new Pagerfanta($adapter);
        $pagerfanta->setMaxPerPage(10);
        $pagerfanta->setCurrentPage($page);
        $entities = $pagerfanta->getCurrentPageResults();

        // Paginator - route generator
        $me = $this;
        $routeGenerator = function($page) use ($me,$ruter)
        {
            return $me->generateUrl($ruter, array('page' => $page));
        };

        // Paginator - view
        $view = new TwitterBootstrapView();
        $pagerHtml = $view->render($pagerfanta, $routeGenerator, array(
            'proximity' => 3,
            'prev_message' => 'Atras',
            'next_message' => 'Adelante',
        ));
        return array($entities,$pagerHtml);
    }


    public function productorEmailRemito($registro){
        $usuario = null;
        $chacraTotal = 0;
        $chacra = 0;
        if($registro->getUsuario()){
            $usuario = $this->coreService()->CRUDBuscarPorId("Usuario",$registro->getUsuario());
            $ref_ = $this->coreService()->CRUDBuscarPorId( ($usuario->getTipo() == 1 ? "Empleado" : "Productor"),$usuario->getReferencia()) ;
            $usuario->setDetalles($ref_);
            $pesoEntrada = number_format($registro->getPesoEntrada(), 2, '.', ',');
            $pesoSalida = number_format($registro->getPesoSalida(), 2, '.', ',');
            if($registro->getPesoSalida()){
                $chacra = $registro->getPesoEntrada() - $registro->getPesoSalida();
                $chacraTotal = number_format($chacra, 2, '.', ',');

            }else{
                $chacraTotal = null;
            }

        }

        return $this->render('CoreBundle:Email:productorEmailRemito.html.twig', array(
            "registro" => $registro,
            "pesoEntrada" => $pesoEntrada,
            "pesoSalida" => $pesoSalida,
            "usuario" => $usuario,
            "chacraTotal" => $chacraTotal
        ));

    }

    public function productorEmailTotales($registro){
        $r = $registro;
        $pesoEntrada = number_format($r->getPesoEntrada(), 2, '.', ',');
        $pesoSalida = number_format($r->getPesoSalida(), 2, '.', ',');
        $p = $this->coreService()->buscarParametrosPorRegistro($r->getId());
        /**
         * @var Resultados  $re
         */
        $re = $this->coreService()->buscarResultadoPorId($r->getId());
        $arrozChacra = number_format($re->getArrozChacra(), 2, '.', ',');
        $arrozSl = number_format($re->getArrozSL(), 2, '.', ',');
        $arrozSSL = number_format($re->getArrozSSL(), 2, '.', ',');
        $servicioSecado = number_format($re->getServicioSecado(), 2, '.', ',');
        $arrozNeto = number_format($re->getArrozNeto(), 2, '.', ',');
        $premioCastigo = number_format($re->getPremioCastigo(), 2, '.', ',');

        return $this->render('CoreBundle:Email:productorEmailTotales.html.twig', array(
            "r"=>$r,
            "pesoEntrada" => $pesoEntrada,
            "pesoSalida" => $pesoSalida,
            "p"=>$p,
            "re"=>$re,
            "arrozChacra" => $arrozChacra,
            "arrozSL" => $arrozSl,
            "arrozSSL" => $arrozSSL,
            "servicioSecado" => $servicioSecado,
            "arrozNeto" => $arrozNeto,
            "premioCastigo" => $premioCastigo
        ));
    }


}

?>
