<?php

namespace Sigza\CoreBundle\Controller;


use Sigza\CoreBundle\Entity\Productor;
use Sigza\CoreBundle\Entity\Registro;
use Sigza\CoreBundle\Entity\Resultados;
use Sigza\CoreBundle\Entity\Usuario;
use Sigza\CoreBundle\Form\UsuarioType;
use Ps\PdfBundle\Annotation\Pdf;
use Symfony\Component\HttpFoundation\Response;

class DefaultController extends CommonController
{

    public function userInfoAction($id, $tipo){
        $nombre = "";
        if($tipo && $id){
            $ref_ = $this->coreService()->CRUDBuscarPorId( ($tipo == 1 ? "Empleado" : "Productor"),$id) ;
            $nombre = $ref_ ->getNombre().( $tipo == 1 ? ' '. $ref_->getApellidos() : '' );

        }
        return $this->responseJSON("{\"nombre\":\"".$nombre."\"}");
    }

    public function chacrasProductorAction(){
        $id = $this->getParam("id");
        $chacras = "[";
        if($id){
            $chs = $this->coreService()->chacrasPorProductor($id)->getQuery()->getResult();
            for($i = 0; $i < count($chs); $i++){
                if($i > 0)
                    $this->putJSONString($chacras,",");
                $this->putJSONString($chacras,"{");
                $this->putJSONStringProp($chacras,"id",$chs[$i]->getId(),true);
                $this->putJSONStringProp($chacras,"nombre",$chs[$i]->getNombre(),false);
                $this->putJSONString($chacras,"}");
            }
        }
        $this->putJSONString($chacras,"]");
        return $this->responseJSON("{\"chacras\":".$chacras."}");
    }



    public function loginAction(){
        //if ($this->get('security.context')->isGranted('ROLE_CONSULTA_ADMIN') === true)
            //return $this->redirect($this->generateUrl('ap_homepage'));

        $form = $this->createForm(new UsuarioType(), new Usuario());
        return $this->render('CoreBundle::login.html.twig', array('form' => $form->createView(),'error'=>  $this->getRequest()->getSession()->get(\Symfony\Component\Security\Core\SecurityContext::AUTHENTICATION_ERROR)));
    }

    public function homeAction(){
        if($this->getUser())
            return $this->render('CoreBundle::index.html.twig');
        else
            return $this->redirect($this->generateUrl("login"));
    }

    public function registrarseAction(){
        return $this->render('CoreBundle:Default:registrarse.html.twig');
    }

    private function notEmpty($val){
        return $val != null && $val != '';
    }

    public function listarAction()
    {
        $parametros = array();
        $estadoremito = 0;
        $pagerHtml = null;

        $remito = $this->getParam("remito");
        $fi = $this->getParam("fi");
        $ff = $this->getParam("ff");

        $matricula = $this->getParam("matricula");
        $estado = $this->getParam("estado");
        $remitoProductor = $this->getParam("remitoProductor");
        $productores = $this->coreService()->CRUDlistar("Productor");
        //Nuevos filtros
        $variedades = $this->coreService()->CRUDlistar("Variedad");
        $chacras = $this->coreService()->CRUDlistar("Chacra");
        $variedad = $this->getParam("variedad");
        $chacra = $this->getParam("chacra");
        $empresas = $this->coreService()->CRUDlistar("Empresa");
        $empresa = $this->getParam("empresa");

        $filtros = array();
        $filtros["fi"] = $this->notEmpty($fi)  ? date_create_from_format("d/m/Y",$fi) : null ;
        $filtros["ff"] = $this->notEmpty($ff)  ? date_create_from_format("d/m/Y",$ff) : null ;

        $filtros["remito"] = $remito ? $remito : null ;
        $filtros["matricula"] = $matricula ? $matricula : null ;
        $filtros["estado"] = $estado ? $estado : -1 ;
        //Nuevos Filtros
        $filtros["remitoProductor"] = $remitoProductor ? $remitoProductor : null ;
        $filtros["variedad"] = $variedad && $variedad != -1 ? $variedad : null;
        $filtros["chacra"] = $chacra && $chacra != -1 ? $chacra : null;
        $filtros["empresa"] = $empresa && $empresa != -1 ? $empresa : null;
        $chacraTotal = 0;
        $netoTotal = 0;

        $user = $this->getUser();
        $productor = null; // id de usuario logeado
        if($user->getTipo() == 2){
            $productor = $user->getReferencia();
            $filtros["productor"] = $productor ? $productor : null;
            //$chacras = $this->coreService()->chacrasPorProductor($productor)->getQuery()->getResult();
        }

        $admin = $productor == null ? 1 : 0;
        if($admin == 1){
            $productor = $this->getParam("productor");
            $productor = $productor == null || $productor == -1 ? null : $productor;
        }


        $filtros["planta"] = $admin == 1 ? $user->getPlanta() : null;
        $filtros["productor"] = $productor ? $productor : null;


        $page = $this->getParam("page");
        if(!$page)
            $page = 1;

        $queryBuilder = $this->coreService()->listarInfoProductorQuery($filtros);
        $totales = $this->coreService()->totales($filtros);
        $chacraTotal = number_format($totales[0], 2, '.', ',');
        $netoTotal =  number_format($totales[1], 2, '.', ',');
        list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"productor_remitos_listar");

        $data = array();
        for($i =0; $i<count($entities);$i++){
            $dataRemito = array();
            /**
             * @var Registro $r
             */
            $r = $entities[$i];
            $cerrado = $r->getCerrado();

            if ($cerrado == null || $cerrado == false)
                $estadoremito = -1;
            else
                $estadoremito = 1;

            $dataRemito["id"]=$r->getId(); //Id en Registro
            $dataRemito["registro"]=$r;
            $dataRemito["remito"]=$r->getRemito();
            $dataRemito["estado"]=$estadoremito;
            $dataRemito["matricula"]=$r->getCamion()->getMatricula();
            $dataRemito["planta"]=$r->getPlanta()->getNombre();
            $dataRemito["fechaEntrada"]=$r->getFechaEntrada();
            $dataRemito["Productor"]=$r->getProductor()->getNombre();
            if($r->getFechaSalida()== null)
                $dataRemito["fechaSalida"]="";
            else
                $dataRemito["fechaSalida"]=$r->getFechaSalida();

            $parametros = $this->coreService()->CRUDBuscarPorId("Parametros",$r->getId());
            if($parametros->getCerrado()){
                $dataRemito["Cerrado"]= 1;
            }else{
                $dataRemito["Cerrado"]= -1;
            }
            /**
             * @var Resultados $resultados
             */
            $resultados = $this->coreService()->CRUDBuscarPorId("Resultados",$r->getId());//resultados por registro

            if($resultados->getArrozChacra() == null){
                $dataRemito["Chacra"]="-";
            }else{
                $dataRemito["Chacra"]=number_format($resultados->getArrozChacra(), 2, '.', ',');
            }
            if($resultados->getArrozNeto() == null){

                $dataRemito["Neto"]="-";
            }else{
                $dataRemito["Neto"]=number_format($resultados->getArrozNeto(), 2, '.', ',');
            }
            array_push($data,$dataRemito);
        }

        //$parametros = $this->coreService()->listarInfoProductor($filtros);

        return $this->render('CoreBundle:Default:productorListar.html.twig', array(

            "data"=>$data,
            "fi"=>$fi,
            "ff"=>$ff,
            "remito"=>$remito,
            "matricula"=>$matricula,
            "estado"=>$estado,
            "admin"=>$admin,
            "productores"=>$productores,
            "productor"=>$productor == null ? -1 : $productor,
            'pagerHtml' => $pagerHtml,
            'chacraTotal'=>$chacraTotal,
            'netoTotal'=>$netoTotal,
            "remitoProductor"=>$remitoProductor,
            "variedades"=>$variedades,
            "variedad"=>$variedad == null ? -1 : $variedad,
            "chacras"=>$chacras,
            "chacra"=>$chacra == null ? -1 : $chacra,
            "empresas"=>$empresas,
            "empresa"=>$empresa == null ? -1 : $empresa

        ));
    }

    public function showAction($id){
        $r = $this->coreService()->buscarRegistroPorId($id);
        $pesoEntrada = number_format($r->getPesoEntrada(), 2, '.', ',');
        $pesoSalida = number_format($r->getPesoSalida(), 2, '.', ',');
        $p = $this->coreService()->buscarParametrosPorRegistro($id);
        /**
         * @var Resultados  $re
         */
        $re = $this->coreService()->buscarResultadoPorId($id);
        $arrozChacra = number_format($re->getArrozChacra(), 2, '.', ',');
        $arrozSl = number_format($re->getArrozSL(), 2, '.', ',');
        $arrozSSL = number_format($re->getArrozSSL(), 2, '.', ',');
        $servicioSecado = number_format($re->getServicioSecado(), 2, '.', ',');
        $arrozNeto = number_format($re->getArrozNeto(), 2, '.', ',');
        $premioCastigo = number_format($re->getPremioCastigo(), 2, '.', ',');

        return $this->render('CoreBundle:Default:productorShow.html.twig', array(
            "r"=>$r,
            "pesoEntrada" => $pesoEntrada,
            "pesoSalida" => $pesoSalida,
            "p"=>$p,
            "re"=>$re,
            "arrozChacra" => $arrozChacra,
            "arrozSL" => $arrozSl,
            "arrozSSL" => $arrozSSL,
            "servicioSecado" => $servicioSecado,
            "arrozNeto" => $arrozNeto,
            "premioCastigo" => $premioCastigo
        ));
    }

    public function showMovilAction($id){
        $r = $this->coreService()->buscarRegistroPorId($id);
        $pesoEntrada = number_format($r->getPesoEntrada(), 2, '.', ',');
        $pesoSalida = number_format($r->getPesoSalida(), 2, '.', ',');
        $p = $this->coreService()->buscarParametrosPorRegistro($id);
        /**
         * @var Resultados  $re
         */
        $re = $this->coreService()->buscarResultadoPorId($id);
        $arrozChacra = number_format($re->getArrozChacra(), 2, '.', ',');
        $arrozSl = number_format($re->getArrozSL(), 2, '.', ',');
        $arrozSSL = number_format($re->getArrozSSL(), 2, '.', ',');
        $servicioSecado = number_format($re->getServicioSecado(), 2, '.', ',');
        $arrozNeto = number_format($re->getArrozNeto(), 2, '.', ',');
        $premioCastigo = number_format($re->getPremioCastigo(), 2, '.', ',');

        return $this->render('CoreBundle:Default:productorShowMovil.html.twig', array(
            "r"=>$r,
            "pesoEntrada" => $pesoEntrada,
            "pesoSalida" => $pesoSalida,
            "p"=>$p,
            "re"=>$re,
            "arrozChacra" => $arrozChacra,
            "arrozSL" => $arrozSl,
            "arrozSSL" => $arrozSSL,
            "servicioSecado" => $servicioSecado,
            "arrozNeto" => $arrozNeto,
            "premioCastigo" => $premioCastigo
        ));
    }


    public function listarMovilAction()
    {
        $parametros = array();
        $estadoremito = 0;
        $pagerHtml = null;

        $remito = $this->getParam("remito");
        $fi = $this->getParam("fi");
        $ff = $this->getParam("ff");

        $matricula = $this->getParam("matricula");
        $estado = $this->getParam("estado");
        $remitoProductor = $this->getParam("remitoProductor");
        $productores = $this->coreService()->CRUDlistar("Productor");
        //Nuevos filtros
        $variedades = $this->coreService()->CRUDlistar("Variedad");
        $chacras = $this->coreService()->CRUDlistar("Chacra");
        $variedad = $this->getParam("variedad");
        $chacra = $this->getParam("chacra");
        $empresas = $this->coreService()->CRUDlistar("Empresa");
        $empresa = $this->getParam("empresa");

        $filtros = array();
        $filtros["fi"] = $this->notEmpty($fi)  ? date_create_from_format("d/m/Y",$fi) : null ;
        $filtros["ff"] = $this->notEmpty($ff)  ? date_create_from_format("d/m/Y",$ff) : null ;

        $filtros["remito"] = $remito ? $remito : null ;
        $filtros["matricula"] = $matricula ? $matricula : null ;
        $filtros["estado"] = $estado ? $estado : -1 ;
        //Nuevos Filtros
        $filtros["remitoProductor"] = $remitoProductor ? $remitoProductor : null ;
        $filtros["variedad"] = $variedad && $variedad != -1 ? $variedad : null;
        $filtros["chacra"] = $chacra && $chacra != -1 ? $chacra : null;
        $filtros["empresa"] = $empresa && $empresa != -1 ? $empresa : null;
        $chacraTotal = 0;
        $netoTotal = 0;

        $user = $this->getUser();
        $productor = null; // id de usuario logeado
        if($user->getTipo() == 2){
            $productor = $user->getReferencia();
            $filtros["productor"] = $productor ? $productor : null;
            //$chacras = $this->coreService()->chacrasPorProductor($productor)->getQuery()->getResult();
        }

        $admin = $productor == null ? 1 : 0;
        if($admin == 1){
            $productor = $this->getParam("productor");
            $productor = $productor == null || $productor == -1 ? null : $productor;
        }


        $filtros["planta"] = $admin == 1 ? $user->getPlanta() : null;
        $filtros["productor"] = $productor ? $productor : null;


        $page = $this->getParam("page");
        if(!$page)
            $page = 1;

        $queryBuilder = $this->coreService()->listarInfoProductorQuery($filtros);
        $totales = $this->coreService()->totales($filtros);
        $chacraTotal = number_format($totales[0], 2, '.', ',');
        $netoTotal =  number_format($totales[1], 2, '.', ',');
        list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"productor_remitos_listar");

        $data = array();
        for($i =0; $i<count($entities);$i++){
            $dataRemito = array();
            /**
             * @var Registro $r
             */
            $r = $entities[$i];
            $cerrado = $r->getCerrado();

            if ($cerrado == null || $cerrado == false)
                $estadoremito = -1;
            else
                $estadoremito = 1;

            $dataRemito["id"]=$r->getId(); //Id en Registro
            $dataRemito["registro"]=$r;
            $dataRemito["remito"]=$r->getRemito();
            $dataRemito["estado"]=$estadoremito;
            $dataRemito["matricula"]=$r->getCamion()->getMatricula();
            $dataRemito["planta"]=$r->getPlanta()->getNombre();
            $dataRemito["fechaEntrada"]=$r->getFechaEntrada();
            $dataRemito["Productor"]=$r->getProductor()->getNombre();
            if($r->getFechaSalida()== null)
                $dataRemito["fechaSalida"]="";
            else
                $dataRemito["fechaSalida"]=$r->getFechaSalida();

            $parametros = $this->coreService()->CRUDBuscarPorId("Parametros",$r->getId());
            if($parametros->getCerrado()){
                $dataRemito["Cerrado"]= 1;
            }else{
                $dataRemito["Cerrado"]= -1;
            }
            /**
             * @var Resultados $resultados
             */
            $resultados = $this->coreService()->CRUDBuscarPorId("Resultados",$r->getId());//resultados por registro

            if($resultados->getArrozChacra() == null){
                $dataRemito["Chacra"]="-";
            }else{
                $dataRemito["Chacra"]=number_format($resultados->getArrozChacra(), 2, '.', ',');
            }
            if($resultados->getArrozNeto() == null){

                $dataRemito["Neto"]="-";
            }else{
                $dataRemito["Neto"]=number_format($resultados->getArrozNeto(), 2, '.', ',');
            }
            array_push($data,$dataRemito);
        }

        //$parametros = $this->coreService()->listarInfoProductor($filtros);

        return $this->render('CoreBundle:Default:productorListarMovil.html.twig', array(

            "data"=>$data,
            "fi"=>$fi,
            "ff"=>$ff,
            "remito"=>$remito,
            "matricula"=>$matricula,
            "estado"=>$estado,
            "admin"=>$admin,
            "productores"=>$productores,
            "productor"=>$productor == null ? -1 : $productor,
            'pagerHtml' => $pagerHtml,
            'chacraTotal'=>$chacraTotal,
            'netoTotal'=>$netoTotal,
            "remitoProductor"=>$remitoProductor,
            "variedades"=>$variedades,
            "variedad"=>$variedad == null ? -1 : $variedad,
            "chacras"=>$chacras,
            "chacra"=>$chacra == null ? -1 : $chacra,
            "empresas"=>$empresas,
            "empresa"=>$empresa == null ? -1 : $empresa
        ));
    }

    /**
     * @Pdf()
     */
    public function printRemitoAction($id){
        $format = $this->get('request')->get('_format');
        $registro = $this->coreService()->buscarRegistroPorId($id);
        if($registro){
            $usuario = null;
            if($registro->getUsuario()){
                $usuario = $this->coreService()->CRUDBuscarPorId("Usuario",$registro->getUsuario());
                $ref_ = $this->coreService()->CRUDBuscarPorId( ($usuario->getTipo() == 1 ? "Empleado" : "Productor"),$usuario->getReferencia()) ;
                $usuario->setDetalles($ref_);
            }
            $response = $this->render(sprintf('CoreBundle::print_remito.%s.twig', $format), array(
                'registro'=>$registro,
                "usuario"=>$usuario));
            $response->headers->set("Content-Disposition","attachment; filename=\"reporte.pdf\"");
            return $response;
        }
        return $this->redirect($this->generateUrl("core_home"));
    }

    /**
     * @Pdf()
     */
    public function printParametrosAction($id){
        $format = $this->get('request')->get('_format');
        $parametros = $this->coreService()->buscarParametrosPorRegistro($id);
        if($parametros){
            $usuario = null;
            if($parametros->getId()->getUsuario()){
                $usuario = $this->coreService()->CRUDBuscarPorId("Usuario",$parametros->getId()->getUsuario());
                $ref_ = $this->coreService()->CRUDBuscarPorId( ($usuario->getTipo() == 1 ? "Empleado" : "Productor"),$usuario->getReferencia()) ;
                $usuario->setDetalles($ref_);
            }
            $response = $this->render(sprintf('CoreBundle::print_parametros.%s.twig', $format), array('parametros'=>$parametros,
                "usuario"=>$usuario));
            $response->headers->set("Content-Disposition","attachment; filename=\"reporte.pdf\"");
            return $response;
        }
        return $this->redirect($this->generateUrl("core_home"));
    }

    public function notificacionesAction($id){
        /**
         * @var Productor $productor
         */
        $productor = $this->coreService()->CRUDBuscarPorId("Productor",$id);
        if($productor){
            if($this->isPost()){
                $remitoCerrado = $this->getParam("remito_cerrado");
                $balanzaCerrada = $this->getParam("balanza_cerrada");
                $productor->setNotificacionBalanzaCerrada( $balanzaCerrada == 1 );
                $productor->setNotificacionRemitoCerrado( $remitoCerrado == 1);
                $this->coreService()->save($productor,true);
                return $this->redirect($this->generateUrl("core_home"));
            }
            return $this->render('CoreBundle:Default:productorNotificaciones.html.twig', array(
                'productor'=>$productor
            ));
        }
        return $this->redirect($this->generateUrl("core_home"));
    }


    public function notificacionesMovilAction($id){
        /**
         * @var Productor $productor
         */
        $productor = $this->coreService()->CRUDBuscarPorId("Productor",$id);
        if($productor){
            if($this->isPost()){
                $remitoCerrado = $this->getParam("remito_cerrado");
                $balanzaCerrada = $this->getParam("balanza_cerrada");
                $productor->setNotificacionBalanzaCerrada( $balanzaCerrada == 1 );
                $productor->setNotificacionRemitoCerrado( $remitoCerrado == 1);
                $this->coreService()->save($productor,true);
                return $this->redirect($this->generateUrl("core_home"));
            }
            return $this->render('CoreBundle:Default:productorNotificacionesMovil.html.twig', array(
                'productor'=>$productor
            ));
        }
        return $this->redirect($this->generateUrl("productor_remitos_show_movil"));
    }





}
