<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 28/01/14
 * Time: 22:52
 */

namespace Sigza\CoreBundle\Controller;
use Symfony\Component\HttpFoundation\Request;

class EmpresaController extends CommonCRUDController{
    function __construct()
    {
        $this->entityName = "Empresa";
        $this->notFoundMessage = "No se pudo encontrar la empresa solicitada";
        $this->sigle = "Empresa";
        $this->plural = "Empresas";
    }

    public function newAction()
    {
        $m = $this->getParam("m");
        $entity = $this->buildEntity();
        $form = $this->buildType($entity);
        return $this->render($this->bundleName.":".$this->entityName.":new.html.twig", array(
            'entity' => $entity,
            'form'   => $form->createView(),
            'entityName' => $this->entityName,
            'title'=>"Crear ".$this->sigle,
            'retorno'=>$this->getParam("retorno"),
            'bundleName'=>$this->bundleName,
            'm'=>$m
        ));

    }

    public function createAction(Request $request)
    {
        $m = $this->getParam("m");
        $entity = $this->buildEntity();
        $form = $this->buildType($entity);
        $form->submit($request);
        $retorno = $this->getParam("retorno");
        if ($form->isValid()) {
            $this->save($entity);
            if($retorno == null || $retorno == '')
                return $this->redirect($this->generateUrl($this->entityName.'_show', array('id' => $entity->getId())));

            $rs = str_getcsv($retorno,",");
            $r = $rs[ count($rs) - 1 ];
            $retorno = "";
            for($i = 0; $i < count($rs) - 1; $i++){
                if($i > 0)
                    $retorno.=',';
                $retorno.=$rs[$i];
            }


            return $this->redirect($this->generateUrl($r, array('id' => $entity->getId(),"retorno"=>$retorno,'m'=>$m)));
        }
        return $this->render($this->bundleName.":".$this->entityName.":new.html.twig", array(
            'entity' => $entity,
            'form'   => $form->createView(),
            'entityName' => $this->entityName,
            'title'=>"Crear ".$this->sigle,
            'retorno'=>$retorno,
            'bundleName'=>$this->bundleName,
            'm'=>$m
        ));
    }
} 