<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 2/02/14
 * Time: 12:46
 */

namespace Sigza\CoreBundle\Entity;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;


/**
 * @ORM\Table(name="base")
 * @ORM\Entity(repositoryClass="BaseRepository")
 */

class Base {

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     * @Assert\Range(min=0, minMessage="Este valor debe ser positivo",
     * max=100, maxMessage="Este valor no debe exceder 100",
     * invalidMessage="Debe introducir valor numérico")
     */
    protected $humedad;

    /**
     * @ORM\Column(type="decimal", scale=2, name="verde", nullable=true)
     */
    protected $verde;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $basura;

    /**
     * @ORM\Column(type="decimal", scale=2, name="base_cargo", nullable=true)
     */
    protected $baseCargo;



    /**
     * @ORM\Column(type="decimal", scale=2, name="base_blanco", nullable=true)
     */
    protected $baseBlanco;

    /**
     * @ORM\OneToMany(targetEntity="BaseGranoEnteroVariedad",mappedBy="base",cascade={"persist"})
     */
    protected $granoEntero;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $quebrado;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $yeso;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $rojo;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $mancha;

    /**
     * @ORM\Column(type="decimal", scale=2, name="servicio_secado", nullable=true)
     */
    protected $servicioSecado;

    /**
     * @ORM\ManyToOne(targetEntity="Productor", inversedBy="registro")
     * @ORM\JoinColumn(name="productor", referencedColumnName= "id")
     */
    protected $productor;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->granoEntero = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * @param mixed $servicioSecado
     */
    public function setServicioSecado($servicioSecado)
    {
        $this->servicioSecado = $servicioSecado;
    }

    /**
     * @return mixed
     */
    public function getServicioSecado()
    {
        return $this->servicioSecado;
    }



    /**
     * @param mixed $baseBlanco
     */
    public function setBaseBlanco($baseBlanco)
    {
        $this->baseBlanco = $baseBlanco;
    }

    /**
     * @return mixed
     */
    public function getBaseBlanco()
    {
        return $this->baseBlanco;
    }

    /**
     * @param mixed $baseCargo
     */
    public function setBaseCargo($baseCargo)
    {
        $this->baseCargo = $baseCargo;
    }

    /**
     * @return mixed
     */
    public function getBaseCargo()
    {
        return $this->baseCargo;
    }

    /**
     * @param mixed $basura
     */
    public function setBasura($basura)
    {
        $this->basura = $basura;
    }

    /**
     * @return mixed
     */
    public function getBasura()
    {
        return $this->basura;
    }

    /**
     * @param mixed $granoEntero
     */
    public function setGranoEntero($granoEntero)
    {
        $this->granoEntero = $granoEntero;
    }

    /**
     * @return mixed
     */
    public function getGranoEntero()
    {
        return $this->granoEntero;
    }

    /**
     * @param mixed $humedad
     */
    public function setHumedad($humedad)
    {
        $this->humedad = $humedad;
    }

    /**
     * @return mixed
     */
    public function getHumedad()
    {
        return $this->humedad;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $mancha
     */
    public function setMancha($mancha)
    {
        $this->mancha = $mancha;
    }

    /**
     * @return mixed
     */
    public function getMancha()
    {
        return $this->mancha;
    }

    /**
     * @param mixed $quebrado
     */
    public function setQuebrado($quebrado)
    {
        $this->quebrado = $quebrado;
    }

    /**
     * @return mixed
     */
    public function getQuebrado()
    {
        return $this->quebrado;
    }

    /**
     * @param mixed $rojo
     */
    public function setRojo($rojo)
    {
        $this->rojo = $rojo;
    }

    /**
     * @return mixed
     */
    public function getRojo()
    {
        return $this->rojo;
    }

    /**
     * @param mixed $verde
     */
    public function setVerde($verde)
    {
        $this->verde = $verde;
    }

    /**
     * @return mixed
     */
    public function getVerde()
    {
        return $this->verde;
    }


    /**
     * @param mixed $yeso
     */
    public function setYeso($yeso)
    {
        $this->yeso = $yeso;
    }

    /**
     * @return mixed
     */
    public function getYeso()
    {
        return $this->yeso;
    }

    public function granoEnteroDe($id){
        for($i = 0; $i < count($this->granoEntero); $i++){
            if($this->granoEntero[$i]->getVariedad()->getId() == $id)
                return $this->granoEntero[$i]->getValor();
        }
        return "";
    }

    public function addVariedad(BaseGranoEnteroVariedad $v){
        $this->granoEntero->add($v);
    }

    public function setProductor($productor)
    {
        $this->productor = $productor;
    }

    public function getProductor()
    {
        return $this->productor;
    }


} 