<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Maikel
 * Date: 2/3/14
 * Time: 11:24 PM
 * To change this template use File | Settings | File Templates.
 */

namespace Sigza\CoreBundle\Entity;


use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;


/**
 * @ORM\Table(name="base_grano_entero_variedad")
 * @ORM\Entity(repositoryClass="BaseGranoEnteroVariedadRepository")
 */
class BaseGranoEnteroVariedad {
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $valor;

    /**
     * @ORM\ManyToOne(targetEntity="Variedad")
     * @ORM\JoinColumn(name="variedad", referencedColumnName= "id")
     */
    protected $variedad;

    /**
     * @ORM\ManyToOne(targetEntity="Base")
     * @ORM\JoinColumn(name="base", referencedColumnName= "id")
     */
    protected $base;

    public function setBase($base)
    {
        $this->base = $base;
    }

    public function getBase()
    {
        return $this->base;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function getId()
    {
        return $this->id;
    }

    public function setVariedad($variedad)
    {
        $this->variedad = $variedad;
    }

    public function getVariedad()
    {
        return $this->variedad;
    }

    public function setValor($valor)
    {
        $this->valor = $valor;
    }

    public function getValor()
    {
        return $this->valor;
    }


}