<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 22/01/14
 * Time: 17:06
 */

namespace Sigza\CoreBundle\Entity;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

/**
 * @UniqueEntity(fields="matricula",message="Esta matrícula ya está asiganada")
 * @ORM\Table(name="camion")
 * @ORM\Entity(repositoryClass="CamionRepository")
 */

class Camion {
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @ORM\Column(type="string", length=150)
     * @Assert\NotBlank(message="La matricula no puede estar en blanco")
     */
    protected $matricula;

    /**
     * @ORM\OneToMany(targetEntity="Registro",mappedBy="camion")
     */
    protected $registro;

    /**
     * @ORM\ManyToOne(targetEntity="Empresa", inversedBy="camion")
     * @ORM\JoinColumn(name="empresa", referencedColumnName= "id")
     */
    protected $empresa;

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $matricula
     */
    public function setMatricula($matricula)
    {
        $this->matricula = $matricula;
    }

    /**
     * @return mixed
     */
    public function getMatricula()
    {
        return $this->matricula;
    }

    /**
     * @param mixed $registro
     */
    public function setRegistro($registro)
    {
        $this->registro = $registro;
    }

    /**
     * @return mixed
     */
    public function getRegistro()
    {
        return $this->registro;
    }

    /**
     * @param mixed $empresa
     */
    public function setEmpresa($empresa)
    {
        $this->empresa = $empresa;
    }

    /**
     * @return mixed
     */
    public function getEmpresa()
    {
        return $this->empresa;
    }


} 