<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 27/01/14
 * Time: 14:02
 */

namespace Sigza\CoreBundle\Entity;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Table(name="chacra")
 * @ORM\Entity(repositoryClass="ChacraRepository")
 */

class Chacra {

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @ORM\Column(type="string", length=150)
     * @Assert\NotBlank(message="Tiene que rellenar este dato")
     */
    protected $nombre;

    /**
     * @ORM\ManyToOne(targetEntity="Productor", inversedBy="chacra")
     * @ORM\JoinColumn(name="productor", referencedColumnName= "id")
     */
    protected $productor;

    /**
     * @ORM\OneToMany(targetEntity="Registro",mappedBy="chacra")
     */
    protected $registro;

    /**
     * @param mixed $registro
     */
    public function setRegistro($registro)
    {
        $this->registro = $registro;
    }

    /**
     * @return mixed
     */
    public function getRegistro()
    {
        return $this->registro;
    }



    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $nombre
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    }

    /**
     * @return mixed
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * @param mixed $productor
     */
    public function setProductor($productor)
    {
        $this->productor = $productor;
    }

    /**
     * @return mixed
     */
    public function getProductor()
    {
        return $this->productor;
    }





} 