<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Maikel
 * Date: 2/7/14
 * Time: 5:14 PM
 * To change this template use File | Settings | File Templates.
 */

namespace Sigza\CoreBundle\Entity;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;


/**
 * @ORM\Table(name="empleado")
 * @ORM\Entity(repositoryClass="EmpleadoRepository")
 */

class Empleado {

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(type="string")
     */
    protected $nombre;

    /**
     * @ORM\Column(type="string")
     */
    protected $apellidos;

    /**
     * @ORM\Column(type="string")
     */
    protected $documento;

    /**
     * @ORM\ManyToOne(targetEntity="TipoDocumentos")
     * @ORM\JoinColumn(name="tipo_documento", referencedColumnName= "id")
     */
    protected $tipoDocumento;

    /**
     * @ORM\ManyToOne(targetEntity="Planta")
     * @ORM\JoinColumn(name="planta", referencedColumnName= "id")
     */
    protected $planta;

    public function setApellidos($apellidos)
    {
        $this->apellidos = $apellidos;
    }

    public function getApellidos()
    {
        return $this->apellidos;
    }

    public function setDocumento($documento)
    {
        $this->documento = $documento;
    }

    public function getDocumento()
    {
        return $this->documento;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function getId()
    {
        return $this->id;
    }

    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    }

    public function getNombre()
    {
        return $this->nombre;
    }

    public function setPlanta($planta)
    {
        $this->planta = $planta;
    }

    public function getPlanta()
    {
        return $this->planta;
    }

    public function setTipoDocumento($tipoDocumento)
    {
        $this->tipoDocumento = $tipoDocumento;
    }

    public function getTipoDocumento()
    {
        return $this->tipoDocumento;
    }
}