<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 28/01/14
 * Time: 22:15
 */

namespace Sigza\CoreBundle\Entity;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Table(name="empresa")
 * @ORM\Entity(repositoryClass="EmpresaRepository")
 */
class Empresa {
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @ORM\Column(type="string", length=150)
     * @Assert\NotBlank(message="El nombre no debe dejarse en blanco")
     */
    protected $nombre;

    /**
     * @ORM\Column(type="string", length=150)
     * @Assert\NotBlank(message="El número de contribuyente no debe dejarse en blanco")
     */
    protected $contribuyente;

    /**
     * @ORM\OneToMany(targetEntity="Camion",mappedBy="empresa")
     */
    protected $camiones;

    /**
     * @param mixed $contribuyente
     */
    public function setContribuyente($contribuyente)
    {
        $this->contribuyente = $contribuyente;
    }

    /**
     * @return mixed
     */
    public function getContribuyente()
    {
        return $this->contribuyente;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $nombre
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    }

    /**
     * @return mixed
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * @param mixed $camiones
     */
    public function setCamiones($camiones)
    {
        $this->camiones = $camiones;
    }

    /**
     * @return mixed
     */
    public function getCamiones()
    {
        return $this->camiones;
    }



} 