<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 22/01/14
 * Time: 16:19
 */

namespace Sigza\CoreBundle\Entity;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Table(name="parametros")
 * @ORM\Entity(repositoryClass="ParametrosRepository")
 */
class Parametros {

    /**
     * @ORM\Id
     * @ORM\OneToOne(targetEntity="Registro")
     * @ORM\JoinColumn(name="id", referencedColumnName="id")
     */
    protected $id;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     * @Assert\Range(min=0, minMessage="Este valor debe ser positivo",
     * max=100, maxMessage="Este valor no debe exceder 100",
     * invalidMessage="Debe introducir valor numérico")
     */
    protected $humedad;

    /**
     * @ORM\Column(type="decimal", scale=2, name="verde_primario", nullable=true)
     */
    protected $verdePrimario;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $basura;

    /**
     * @ORM\Column(type="decimal", scale=2, name="base_cargo", nullable=true)
     */
    protected $baseCargo;

    /**
     * @ORM\Column(type="decimal", scale=2, name="verde_oficial", nullable=true)
     */
    protected $verdeOficial;

    /**
     * @ORM\Column(type="decimal", scale=2, name="base_blanco", nullable=true)
     */
    protected $baseBlanco;

    /**
     * @ORM\Column(type="decimal", scale=2, name="grano_entero", nullable=true)
     */
    protected $granoEntero;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $quebrado;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $yeso;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $rojo;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $mancha;

    /**
     * @ORM\ManyToOne(targetEntity="Variedad", inversedBy="parametros")
     * @ORM\JoinColumn(name="variedad", referencedColumnName= "id")
     */
    protected $variedad;



    /**
     * @ORM\Column(type="boolean")
     */
    protected $cerrado;

    /**
     * @ORM\Column(type="integer")
     */
    protected $usuario;

    /**
     * @param mixed $humedad
     */
    public function setHumedad($humedad)
    {
        $this->humedad = $humedad;
    }

    /**
     * @return mixed
     */
    public function getHumedad()
    {
        return $this->humedad;
    }





    /**
     * @param mixed $baseBlanco
     */
    public function setBaseBlanco($baseBlanco)
    {
        $this->baseBlanco = $baseBlanco;
    }

    /**
     * @return mixed
     */
    public function getBaseBlanco()
    {
        return $this->baseBlanco;
    }

    /**
     * @param mixed $baseCargo
     */
    public function setBaseCargo($baseCargo)
    {
        $this->baseCargo = $baseCargo;
    }

    /**
     * @return mixed
     */
    public function getBaseCargo()
    {
        return $this->baseCargo;
    }

    /**
     * @param mixed $basura
     */
    public function setBasura($basura)
    {
        $this->basura = $basura;
    }

    /**
     * @return mixed
     */
    public function getBasura()
    {
        return $this->basura;
    }

    /**
     * @param mixed $granoEntero
     */
    public function setGranoEntero($granoEntero)
    {
        $this->granoEntero = $granoEntero;
    }

    /**
     * @return mixed
     */
    public function getGranoEntero()
    {
        return $this->granoEntero;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return Registro|null
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $mancha
     */
    public function setMancha($mancha)
    {
        $this->mancha = $mancha;
    }

    /**
     * @return mixed
     */
    public function getMancha()
    {
        return $this->mancha;
    }

    /**
     * @param mixed $quebrado
     */
    public function setQuebrado($quebrado)
    {
        $this->quebrado = $quebrado;
    }

    /**
     * @return mixed
     */
    public function getQuebrado()
    {
        return $this->quebrado;
    }

    /**
     * @param mixed $rojo
     */
    public function setRojo($rojo)
    {
        $this->rojo = $rojo;
    }

    /**
     * @return mixed
     */
    public function getRojo()
    {
        return $this->rojo;
    }



    /**
     * @param mixed $variedad
     */
    public function setVariedad($variedad)
    {
        $this->variedad = $variedad;
    }

    /**
     * @return Variedad|null
     */
    public function getVariedad()
    {
        return $this->variedad;
    }

    /**
     * @param mixed $verdeOficial
     */
    public function setVerdeOficial($verdeOficial)
    {
        $this->verdeOficial = $verdeOficial;
    }

    /**
     * @return mixed
     */
    public function getVerdeOficial()
    {
        return $this->verdeOficial;
    }

    /**
     * @param mixed $verdePrimario
     */
    public function setVerdePrimario($verdePrimario)
    {
        $this->verdePrimario = $verdePrimario;
    }

    /**
     * @return mixed
     */
    public function getVerdePrimario()
    {
        return $this->verdePrimario;
    }

    /**
     * @param mixed $yeso
     */
    public function setYeso($yeso)
    {
        $this->yeso = $yeso;
    }

    /**
     * @return mixed
     */
    public function getYeso()
    {
        return $this->yeso;
    }

    /**
     * @param mixed $cerrado
     */
    public function setCerrado($cerrado)
    {
        $this->cerrado = $cerrado;
    }

    /**
     * @return mixed
     */
    public function getCerrado()
    {
        return $this->cerrado;
    }

    public function setUsuario($usuario)
    {
        $this->usuario = $usuario;
    }

    public function getUsuario()
    {
        return $this->usuario;
    }

} 