<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 22/01/14
 * Time: 16:28
 */

namespace Sigza\CoreBundle\Entity;

use Doctrine\ORM\QueryBuilder;

class ParametrosRepository extends CommonCRUDRepository{

    /**
     * @param $remito
     * @return array
     */
    public function buscarPorRemito($remito){
        $query = $this->_em->createQueryBuilder();
        $query->select("p")->from($this->_entityName,"p");
        $query->innerJoin("p.registro","r","WITH"," LOWER(r.remito) like :remito");
        $query->setParameter("remito",strtolower("%$remito%"));
        $query->setMaxResults(30);
        $result = $query->getQuery()->getResult();
        if(!count($result))
            return array();
        return $result;
    }

    /**
     * @param array $filtros
     * @return array
     */
    public function buscarPorFiltro(array $filtros){
        $planta = "";
        return $this->buscarPorFiltroQuery($filtros, $planta)->getResult();
    }

    public function buscarPorFiltroQuery(array $filtros, $planta){
        $remito = $filtros["remito"];
        $fi = $filtros["fi"];
        $ff = $filtros["ff"];
        $estado = $filtros["estado"];

        $query = $this->_em->createQueryBuilder();
        $query->select("p")->from($this->_entityName,"p");
        $query->innerJoin("p.id","r");


        $query->where(" p.id is not null ");


        if($remito != null){
            $query->andWhere(" LOWER(r.remito) =:remito ");
            $query->setParameter("remito",strtolower($remito));
        }

        if($fi != null){
            $query->andWhere(" r.fechaEntrada >= :fi  ");
            $query->setParameter("fi",$fi);
        }

        if($ff != null){
            $query->andWhere(" r.fechaEntrada <= :ff  ");
            $query->setParameter("ff",$ff);
        }

        if($planta){
            $query->andWhere("r.planta =:planta");
            $query->setParameter("planta",$planta);
        }

        if($estado != -1){
            if($estado == 1)
                $query->andWhere(" r.cerrado = 0 OR r.cerrado is null ");
            else
                $query->andWhere(" r.cerrado = 1 ");
            //$query->setParameter("estado",($estado != 1));
        }
        $query->orderBy("r.fechaEntrada","desc");


        return $query->getQuery();
    }





} 