<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 22/01/14
 * Time: 16:54
 */

namespace Sigza\CoreBundle\Entity;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Table(name="planta")
 * @ORM\Entity(repositoryClass="PlantaRepository")
 */
class Planta {

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @ORM\Column(type="string", length=150)
     * @Assert\NotBlank(message="El nombre no puede estar en blanco")
     */
    protected $nombre;

    /**
     * @ORM\OneToMany(targetEntity="Usuario",mappedBy="planta")
     */
    protected $usuario;

    /**
     * @ORM\OneToMany(targetEntity="Registro",mappedBy="planta")
     */
    protected $registro;

    /**
     * @ORM\Column(type="string")
     * @Assert\NotBlank(message="Especifique los IPs de acceso")
     */
    protected $ips;

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $nombre
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    }

    /**
     * @return mixed
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * @param mixed $registro
     */
    public function setRegistro($registro)
    {
        $this->registro = $registro;
    }

    /**
     * @return mixed
     */
    public function getRegistro()
    {
        return $this->registro;
    }

    /**
     * @param mixed $usuario
     */
    public function setUsuario($usuario)
    {
        $this->usuario = $usuario;
    }

    /**
     * @return mixed
     */
    public function getUsuario()
    {
        return $this->usuario;
    }

    public function setIps($ips)
    {
        $this->ips = $ips;
    }

    public function getIps()
    {
        return $this->ips;
    }





} 