<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 22/01/14
 * Time: 16:29
 */

namespace Sigza\CoreBundle\Entity;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

/**
 * @UniqueEntity(fields="telefonoMovil",message="Este teléfono ya está asignado")
 * @UniqueEntity(fields="email",message="Este email ya está asignado")
 * @ORM\Table(name="productor")
 * @ORM\Entity(repositoryClass="ProductorRepository")
 */
class Productor {

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @ORM\Column(type="string", length=150)
     * @Assert\NotBlank(message="El nombre no puede estar en blanco")
     */
    protected $nombre;

    /**
     * @ORM\Column(type="string", length=150)
     * @Assert\NotBlank(message="El codigo no puede estar en blanco")
     */
    protected $codigo;

    /**
     * @ORM\Column(type="string", length=150, name="documento_identidad")
     * @Assert\NotBlank(message="Por favor Identidad")
     */
    protected $documentoIdentidad;

    /**
     * @ORM\Column(type="string")
     * @Assert\Email()
     */
    protected $email;

    /**
     * @ORM\Column(type="string", length=15, name="telefono_movil")
     */
    protected $telefonoMovil;

    /**
     * @ORM\Column(type="boolean",  name="notificacion_remito_cerrado")
     */
    protected $notificacionRemitoCerrado = true;

    /**
     * @ORM\Column(type="boolean",  name="notificacion_balanza_cerrada")
     */
    protected $notificacionBalanzaCerrada = true;

    /**
     * @ORM\ManyToOne(targetEntity="TipoDocumentos", inversedBy="productor")
     * @ORM\JoinColumn(name="tipo_documentos", referencedColumnName= "id")
     */
    protected $tipoDocumentos;

    /**
     * @ORM\OneToMany(targetEntity="Registro",mappedBy="productor")
     */
    protected $registro;


    /**
     * @ORM\OneToMany(targetEntity="Chacra",mappedBy="productor")
     */
    protected $chacra;

    /**
     * @ORM\OneToMany(targetEntity="Resultados",mappedBy="productor")
     */
    protected $resultados;


    /**
     * @param mixed $chacra
     */
    public function setChacra($chacra)
    {
        $this->chacra = $chacra;
    }

    /**
     * @return mixed
     */
    public function getChacra()
    {
        return $this->chacra;
    }


    /**
     * @param mixed $documentoIdentidad
     */
    public function setDocumentoIdentidad($documentoIdentidad)
    {
        $this->documentoIdentidad = $documentoIdentidad;
    }

    /**
     * @return mixed
     */
    public function getDocumentoIdentidad()
    {
        return $this->documentoIdentidad;
    }

    /**
     * @param mixed $email
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }

    /**
     * @return mixed
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $nombre
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    }

    /**
     * @return mixed
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * @param mixed $registro
     */
    public function setRegistro($registro)
    {
        $this->registro = $registro;
    }

    /**
     * @return mixed
     */
    public function getRegistro()
    {
        return $this->registro;
    }

    /**
     * @param mixed $telefonoMovil
     */
    public function setTelefonoMovil($telefonoMovil)
    {
        $this->telefonoMovil = $telefonoMovil;
    }

    /**
     * @return mixed
     */
    public function getTelefonoMovil()
    {
        return $this->telefonoMovil;
    }

    /**
     * @param mixed $tipoDocumentos
     */
    public function setTipoDocumentos($tipoDocumentos)
    {
        $this->tipoDocumentos = $tipoDocumentos;
    }


    public function getTipoDocumentos()
    {
        return $this->tipoDocumentos;
    }

    /**
     * @param mixed $tolerancia
     */
    public function setTolerancia($tolerancia)
    {
        $this->tolerancia = $tolerancia;
    }

    /**
     * @return mixed
     */
    public function getTolerancia()
    {
        return $this->tolerancia;
    }

    /**
     * @param mixed $resultados
     */
    public function setResultados($resultados)
    {
        $this->resultados = $resultados;
    }

    /**
     * @return mixed
     */
    public function getResultados()
    {
        return $this->resultados;
    }

    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    }

    public function getCodigo()
    {
        return $this->codigo;
    }

    public function setNotificacionBalanzaCerrada($notificacionBalanzaCerrada)
    {
        $this->notificacionBalanzaCerrada = $notificacionBalanzaCerrada;
    }

    public function getNotificacionBalanzaCerrada()
    {
        return $this->notificacionBalanzaCerrada;
    }

    public function setNotificacionRemitoCerrado($notificacionRemitoCerrado)
    {
        $this->notificacionRemitoCerrado = $notificacionRemitoCerrado;
    }

    public function getNotificacionRemitoCerrado()
    {
        return $this->notificacionRemitoCerrado;
    }



} 