<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 22/01/14
 * Time: 16:02
 */

namespace Sigza\CoreBundle\Entity;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

/**
 * @UniqueEntity(fields="remito",message="El remito ya está asignado a otra carga")
 * @ORM\Table(name="registro")
 * @ORM\Entity(repositoryClass="RegistroRepository")
 */
class Registro {

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @ORM\Column(type="string")
     * @Assert\Length(max=150, maxMessage="El Remito solo puede tener 150 caracteres")
     */
    protected $remito;

    /**
     * @ORM\Column(type="string", name="remito_productor")
     * @Assert\Length(max=150, maxMessage="El Remito solo puede tener 150 caracteres")
     */
    protected $remitoProductor;

    /**
     * @ORM\Column(type="datetime", name="fecha_entrada")
     */
    protected $fechaEntrada;

    /**
     * @ORM\Column(type="datetime", name="fecha_salida")
     */
    protected $fechaSalida;


    /**
     * @var \DateTime
     */
    protected $horaEntrada;

    /**
     * @var \DateTime
     */
    protected $horaSalida;


    /**
     * @ORM\Column(type="decimal", scale=2, name="peso_entrada")
     * @Assert\NotBlank(message="Peso en Bruto")
     */
    protected $pesoEntrada;

    /**
     * @ORM\Column(type="decimal", scale=2, name="peso_salida")
     */
    protected $pesoSalida;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $humedad;

    /**
     * @ORM\Column(type="integer")
     */
    protected $usuario;

    /**
     * @ORM\Column(type="string", nullable=true)
     * @Assert\Length(max=500, maxMessage="Solo 500 caracteres por favor")
     */
    protected $observacion;

    /**
     * @ORM\ManyToOne(targetEntity="Productor", inversedBy="registro")
     * @ORM\JoinColumn(name="productor", referencedColumnName= "id")
     */
    protected $productor;

    /**
     * @ORM\ManyToOne(targetEntity="Planta", inversedBy="registro")
     * @ORM\JoinColumn(name="planta", referencedColumnName= "id")
     */
    protected $planta;

    /**
     * @ORM\ManyToOne(targetEntity="Camion", inversedBy="registro")
     * @ORM\JoinColumn(name="camion", referencedColumnName= "id")
     */
    protected $camion;

    /**
     * @ORM\ManyToOne(targetEntity="Producto", inversedBy="registro")
     * @ORM\JoinColumn(name="producto", referencedColumnName= "id")
     */
    protected $producto;

    /**
     * @ORM\ManyToOne(targetEntity="OrigenDestino", inversedBy="registro")
     * @ORM\JoinColumn(name="origen_destino", referencedColumnName= "id")
     */
    protected $origenDestino;

    /**
     * @ORM\ManyToOne(targetEntity="Chacra", inversedBy="registro")
     * @ORM\JoinColumn(name="chacra", referencedColumnName= "id")
     */
    protected $chacra;

    /**
     * @ORM\ManyToOne(targetEntity="Variedad", inversedBy="registro")
     * @ORM\JoinColumn(name="variedad", referencedColumnName= "id")
     */
    protected $variedad;

    /**
     * @ORM\Column(type="boolean", scale=2, nullable=true)
     */
    protected $cerrado;

    /**
     * @param mixed $variedad
     */
    public function setVariedad($variedad)
    {
        $this->variedad = $variedad;
    }

    /**
     * @return mixed
     */
    public function getVariedad()
    {
        return $this->variedad;
    }


    /**
     * @param mixed $usuario
     */
    public function setUsuario($usuario)
    {
        $this->usuario = $usuario;
    }

    /**
     * @return mixed
     */
    public function getUsuario()
    {
        return $this->usuario;
    }



    /**
     * @param mixed $remitoProductor
     */
    public function setRemitoProductor($remitoProductor)
    {
        $this->remitoProductor = $remitoProductor;
    }

    /**
     * @return mixed
     */
    public function getRemitoProductor()
    {
        return $this->remitoProductor;
    }

    /**
     * @param mixed $observacion
     */
    public function setObservacion($observacion)
    {
        $this->observacion = $observacion;
    }

    /**
     * @return mixed
     */
    public function getObservacion()
    {
        return $this->observacion;
    }



    /**
     * @param mixed $chacra
     */
    public function setChacra($chacra)
    {
        $this->chacra = $chacra;
    }

    /**
     * @return mixed
     */
    public function getChacra()
    {
        return $this->chacra;
    }


    /**
     * @param mixed $origenDestino
     */
    public function setOrigenDestino($origenDestino)
    {
        $this->origenDestino = $origenDestino;
    }

    /**
     * @return mixed
     */
    public function getOrigenDestino()
    {
        return $this->origenDestino;
    }


    /**
     * @param mixed $camion
     */
    public function setCamion($camion)
    {
        $this->camion = $camion;
    }

    /**
     * @return Camion|null
     */
    public function getCamion()
    {
        return $this->camion;
    }

    /**
     * @param mixed $fechaEntrada
     */
    public function setFechaEntrada($fecha)
    {
        $this->fechaEntrada = $fecha;
        $this->actualizarHora();
    }

    /**
     * @return mixed
     */
    public function getFechaEntrada()
    {
        return $this->fechaEntrada;
    }


    /**
     * @param mixed $horaEntrada
     */
    public function setHoraEntrada($horaEntrada)
    {
        $this->horaEntrada = $horaEntrada;
        $this->actualizarHora();
    }

    private function actualizarHora(){
        if($this->getFechaEntrada() != null && $this->horaEntrada != null){
            $this->getFechaEntrada()->setTime(date("H",$this->horaEntrada->getTimestamp()),date("i",$this->horaEntrada->getTimestamp()) );
        }
    }



    /**
     * @return mixed
     */
    public function getHoraEntrada()
    {
        if($this->horaEntrada == null){
            $this->horaEntrada = new \DateTime("now");
            if($this->getFechaEntrada() != null){
                $this->horaEntrada->setTimestamp($this->getFechaEntrada()->getTimestamp());
                $this->horaEntrada->setTime( date("H",$this->getFechaEntrada()->getTimestamp()),date("i",$this->getFechaEntrada()->getTimestamp()) );
            }
        }
        return $this->horaEntrada;
    }

    /**
     * @param mixed $humedad
     */
    public function setHumedad($humedad)
    {
        $this->humedad = $humedad;
    }

    /**
     * @return mixed
     */
    public function getHumedad()
    {
        return $this->humedad;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $pesoEntrada
     */
    public function setPesoEntrada($pesoEntrada)
    {
        $this->pesoEntrada = $pesoEntrada;
    }

    /**
     * @return mixed
     */
    public function getPesoEntrada()
    {
        return $this->pesoEntrada;
    }

    /**
     * @param mixed $planta
     */
    public function setPlanta($planta)
    {
        $this->planta = $planta;
    }

    /**
     * @return mixed
     */
    public function getPlanta()
    {
        return $this->planta;
    }

    /**
     * @param mixed $producto
     */
    public function setProducto($producto)
    {
        $this->producto = $producto;
    }

    /**
     * @return mixed
     */
    public function getProducto()
    {
        return $this->producto;
    }

    /**
     * @param mixed $productor
     */
    public function setProductor($productor)
    {
        $this->productor = $productor;
    }

    /**
     * @return mixed
     */
    public function getProductor()
    {
        return $this->productor;
    }

    /**
     * @param mixed $remito
     */
    public function setRemito($remito)
    {
        $this->remito = $remito;
    }

    /**
     * @return mixed
     */
    public function getRemito()
    {
        return $this->remito;
    }


    /**
     * @param mixed $pesoSalida
     */
    public function setPesoSalida($pesoSalida)
    {
        $this->pesoSalida = $pesoSalida;
    }

    /**
     * @return mixed
     */
    public function getPesoSalida()
    {
        return $this->pesoSalida;
    }
    // Proceso para Hora salida y fecha salida
    private function actualizarHoraSalida(){
        if($this->getFechaSalida() != null && $this->horaSalida != null){
            $this->getFechaSalida()->setTime(date("H",$this->horaSalida->getTimestamp()),date("i",$this->horaSalida->getTimestamp()) );
        }
    }

    /**
     * @return mixed
     */
    public function getHoraSalida()
    {
        if($this->horaSalida == null){
            $this->horaSalida = new \DateTime("now");
            if($this->getFechaSalida() != null){
                $this->horaSalida->setTimestamp($this->getFechaSalida()->getTimestamp());
                $this->horaSalida->setTime( date("H",$this->getFechaSalida()->getTimestamp()),date("i",$this->getFechaSalida()->getTimestamp()) );
            }
        }
        return $this->horaSalida;
    }

    /**
     * @param mixed $fechaSalida
     */
    public function setFechaSalida($fecha)
    {
        $this->fechaSalida = $fecha;
        $this->actualizarHoraSalida();
    }

    /**
     * @return mixed
     */
    public function getFechaSalida()
    {
        return $this->fechaSalida;
    }

    /**
     * @param mixed $horaSalida
     */
    public function setHoraSalida($horaSalida)
    {
        $this->horaSalida = $horaSalida;
        $this->actualizarHoraSalida();
    }

    /**
     * @param mixed $cerrado
     */
    public function setCerrado($cerrado)
    {
        $this->cerrado = $cerrado;
    }

    /**
     * @return mixed
     */
    public function getCerrado()
    {
        return $this->cerrado;
    }







} 