<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 22/01/14
 * Time: 16:17
 */

namespace Sigza\CoreBundle\Entity;


class RegistroRepository extends CommonCRUDRepository{

    public function buscarPorRemito($remito){
        $planta = "";
        return $this->buscarPorRemitoQuery($remito, $planta)->getResult();
    }

    /**
     * @param $remito
     * @param $planta
     * @return \Doctrine\ORM\Query
     */
    public function buscarPorRemitoQuery($remito ,$planta ){
        $qb = $this->_em->createQueryBuilder();
        $qb->select("me")->from($this->_entityName,"me")
            ->where("LOWER(me.remito) like :parametro")
        ;

        if($planta){
            $qb->andWhere("me.planta =:planta");
            $qb->setParameter("planta",$planta);
        }
        $qb->addOrderBy("me.fechaEntrada","DESC");
        $qb->setParameter('parametro', strtolower("%$remito%"));
        $qb->setMaxResults(30);

        return $qb->getQuery();
    }

    public function totalChacra($remito ,$planta ){
        $qb = $this->_em->createQueryBuilder();
        $qb->select("SUM(me.pesoEntrada) as ch, SUM(me.pesoSalida) as ch2")->from($this->_entityName,"me")
            ->where("LOWER(me.remito) like :parametro AND me.pesoSalida is not null ")
        ;

        if($planta){
            $qb->andWhere("me.planta =:planta");
            $qb->setParameter("planta",$planta);
        }
        $qb->addOrderBy("me.fechaEntrada","DESC");
        $qb->setParameter('parametro', strtolower("%$remito%"));

        $ch = $qb->getQuery()->getResult();
        $ch = $ch[0];
        $ch1 = $ch["ch"];
        $ch2 = $ch["ch2"];
        return $ch1 - $ch2;
    }



    public function buscarPorRemitosAbiertos($remito){
        return $this->buscarPorRemitosAbiertosQuery($remito, null)->getResult();
    }

    public function buscarPorRemitosAbiertosQuery($remito, $planta){
        /*$query = $this->_em
            ->createQuery("SELECT me FROM Sigza\CoreBundle\Entity\Registro me WHERE LOWER(me.remito) like :parametro AND me.fechaSalida is null "+($planta ? " AND "))
            ->setParameter('parametro', strtolower("%$remito%"));
        $query->setMaxResults(30);*/


        $qb = $this->_em->createQueryBuilder();
        $qb->select("me")->from($this->_entityName,"me")
            ->where("LOWER(me.remito) like :parametro")
        ->andWhere("me.fechaSalida is null")
        ;

        if($planta){
            $qb->andWhere("me.planta =:planta");
            $qb->setParameter("planta",$planta);
        }

        $qb->setParameter('parametro', strtolower("%$remito%"));
        $qb->setMaxResults(30);

        return $qb->getQuery();
    }

    public function listarRemitosAbiertosPorFechaEntrada($planta){
        $qb = $this->_em->createQueryBuilder();
        $qb->select("me")->from($this->_entityName,"me")
            ->where("me.fechaSalida is null")
            ->addOrderBy("me.fechaEntrada","DESC")
        ;
        if($planta){
            $qb->andWhere("me.planta =:planta");
            $qb->setParameter("planta",$planta);
        }
        $qb->setMaxResults(30);

        return $qb->getQuery();
    }

    public function listarRemitosPorFechaEntrada($planta){
        $qb = $this->_em->createQueryBuilder();
        $qb->select("me")->from($this->_entityName,"me")
            ->where("me.id is not null")
            ->addOrderBy("me.fechaEntrada","DESC")
        ;
        if($planta){
            $qb->andWhere("me.planta =:planta");
            $qb->setParameter("planta",$planta);
        }
        $qb->setMaxResults(30);

        return $qb->getQuery();
    }

    /**
     * @param $camion
     * @return mixed
     */
    public function buscarRemitoAbierto($camion){
        $qb = $this->_em->createQueryBuilder();
        $qb->select("r")->from($this->_entityName,"r")
        ->innerJoin("r.camion","c","WITH","c.matricula =:matricula")
        ->andWhere("r.fechaSalida is null")
        ;
        $qb->setParameter("matricula",$camion);
        return $qb->getQuery()->getOneOrNullResult();
    }

    /**
     * @param array $filtros
     * @return array
     */
    public function buscarPorFiltro(array $filtros){
        return $this->buscarPorFiltroQuery($filtros)->getResult();
    }

    public function buscarPorFiltroQuery(array $filtros){
        $remito = $filtros["remito"];
        $fi = $filtros["fi"];
        $ff = $filtros["ff"];
        $estado = $filtros["estado"];
        $productor = $filtros["productor"];
        $matricula = $filtros["matricula"];
        $planta = $filtros["planta"];
        // Nuevos filtros
        $remitoProductor = $filtros["remitoProductor"];
        $variedad = $filtros["variedad"];
        $chacra = $filtros["chacra"];
        $empresa = $filtros["empresa"];

        $query = $this->_em->createQueryBuilder();
        $query->select("r")->from($this->_entityName,"r");

        if($matricula != null){
            $query->innerJoin("r.camion","c");
        }

        if($empresa != null){
            $query->innerJoin("r.camion","c");
        }

        $query->where(" r.id is not null ");

        if($remito != null){
            $query->andWhere(" LOWER(r.remito) =:remito ");
            $query->setParameter("remito",strtolower($remito));
        }

        if($fi != null){
            $query->andWhere(" r.fechaEntrada >= :fi  ");
            $query->setParameter("fi",$fi);
        }

        if($ff != null){
            $query->andWhere(" r.fechaEntrada <= :ff  ");
            $query->setParameter("ff",$ff);
        }

        if($estado != -1){
            if($estado == 1)
                $query->andWhere(" r.cerrado =:estado OR r.cerrado is null ");
            else
                $query->andWhere(" r.cerrado =:estado ");
            $query->setParameter("estado",($estado != 1));
        }

        if($productor != null){
            $query->andWhere(" r.productor =:productor  ");
            $query->setParameter("productor",$productor);
        }

        if($matricula != null){
            $query->andWhere(" c.matricula =:matricula  ");
            $query->setParameter("matricula",$matricula);
        }


        if($planta){
            $query->andWhere(" r.planta =:planta  ");
            $query->setParameter("planta",$planta);
        }

        //Nuevos Filtros
        if($remitoProductor != null){
            $query->andWhere(" LOWER(r.remitoProductor) =:remitoProductor ");
            $query->setParameter("remitoProductor",strtolower($remitoProductor));
        }

        if($variedad){
            $query->andWhere(" r.variedad =:variedad  ");
            $query->setParameter("variedad",$variedad);
        }

        if($chacra){
            $query->andWhere(" r.chacra =:chacra  ");
            $query->setParameter("chacra",$chacra);
        }
        if($empresa){
            $query->andWhere(" c.empresa =:empresa  ");
            $query->setParameter("empresa",$empresa);
        }

        $query->orderBy("r.fechaEntrada","DESC");


        return $query->getQuery();
    }

    public function chacrasTotales(array $filtros){
        $remito = $filtros["remito"];
        $fi = $filtros["fi"];
        $ff = $filtros["ff"];
        $estado = $filtros["estado"];
        $productor = $filtros["productor"];
        $matricula = $filtros["matricula"];
        $planta = $filtros["planta"];

        $query = $this->_em->createQueryBuilder();
        $query->select( "SUM(r.pesoEntrada) as ch, SUM(r.pesoSalida) as ch2" )->from($this->_entityName,"r");

        if($matricula != null){
            $query->innerJoin("r.camion","c");
        }


        $query->where(" r.id is not null AND r.pesoSalida is not null ");


        if($remito != null){
            $query->andWhere(" LOWER(r.remito) =:remito ");
            $query->setParameter("remito",strtolower($remito));
        }

        if($fi != null){
            $query->andWhere(" r.fechaEntrada >= :fi  ");
            $query->setParameter("fi",$fi);
        }

        if($ff != null){
            $query->andWhere(" r.fechaEntrada <= :ff  ");
            $query->setParameter("ff",$ff);
        }

        if($estado != -1){
            if($estado == 1)
                $query->andWhere(" r.cerrado =:estado OR r.cerrado is null ");
            else
                $query->andWhere(" r.cerrado =:estado ");
            $query->setParameter("estado",($estado != 1));
        }

        if($productor != null){
            $query->andWhere(" r.productor =:productor  ");
            $query->setParameter("productor",$productor);
        }

        if($matricula != null){
            $query->andWhere(" c.matricula =:matricula  ");
            $query->setParameter("matricula",$matricula);
        }

        if($planta){
            $query->andWhere(" r.planta =:planta  ");
            $query->setParameter("planta",$planta);
        }
        $ch = $query->getQuery()->getResult();
        $ch = $ch[0];
        $ch1 = $ch["ch"];
        $ch2 = $ch["ch2"];
        return $ch1 - $ch2;
    }




} 