<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 2/02/14
 * Time: 12:15
 */

namespace Sigza\CoreBundle\Entity;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
/**
 * @ORM\Table(name="resultados")
 * @ORM\Entity(repositoryClass="ResultadosRepository")
 */
class Resultados {

    /**
     * @ORM\Id
     * @ORM\OneToOne(targetEntity="Registro")
     * @ORM\JoinColumn(name="id", referencedColumnName="id")
     */
    private $id;

    /**
     * @ORM\Column(type="decimal", scale=2, name="arroz_chacra")
     */
    protected $arrozChacra;

    /**
     * @ORM\Column(type="decimal", scale=2, name="arroz_sl")
     */
    protected $arrozSL;
    /**
     * @ORM\Column(type="decimal", scale=2, name="arroz_ssl")
     */
    protected $arrozSSL;

    /**
     * @ORM\Column(type="decimal", scale=2, name="arroz_neto")
     */
    protected $arrozNeto;

    /**
     * @ORM\Column(type="decimal", scale=2, name="servicio_secado")
     */
    protected $servicioSecado;

    /**
     * @ORM\Column(type="decimal", scale=2, name="premio_castigo")
     */
    protected $premioCastigo;

    // Cantidades deducibles y/o bonificaciones

    /**
     * @ORM\Column(type="decimal", scale=2, name="cantidad_basura")
     */
    protected $cantidadBasura;
    /**
     * @ORM\Column(type="decimal", scale=2, name="cantidad_humedad")
     */
    protected $cantidadHumedad;
    /**
     * @ORM\Column(type="decimal", scale=2, name="cantidad_blanco")
     */
    protected $cantidadBlanco;
    /**
     * @ORM\Column(type="decimal", scale=2, name="cantidad_entero")
     */
    protected $cantidadEntero;
    /**
     * @ORM\Column(type="decimal", scale=2, name="cantidad_rojo")
     */
    protected $cantidadRojo;
    /**
     * @ORM\Column(type="decimal", scale=2, name="cantidad_manchados")
     */
    protected $cantidadManchados;
    /**
     * @ORM\Column(type="decimal", scale=2, name="cantidad_yeso")
     */
    protected $cantidadYeso;
    /**
     * @ORM\Column(type="decimal", scale=2, name="cantidad_verde")
     */
    protected $cantidadVerde;



    /**
     * @ORM\ManyToOne(targetEntity="Productor", inversedBy="resultados")
     * @ORM\JoinColumn(name="productor", referencedColumnName= "id")
     */
    protected $productor;

    /**
     * @param mixed $premioCastigo
     */
    public function setPremioCastigo($premioCastigo)
    {
        $this->premioCastigo = $premioCastigo;
    }

    /**
     * @return mixed
     */
    public function getPremioCastigo()
    {
        return $this->premioCastigo;
    }



    /**
     * @param mixed $arrozChacra
     */
    public function setArrozChacra($arrozChacra)
    {
        $this->arrozChacra = $arrozChacra;
    }

    /**
     * @return mixed
     */
    public function getArrozChacra()
    {
        return $this->arrozChacra;
    }




    /**
     * @param mixed $arrozSL
     */
    public function setArrozSL($arrozSL)
    {
        $this->arrozSL = $arrozSL;
    }

    /**
     * @return mixed
     */
    public function getArrozSL()
    {
        return $this->arrozSL;
    }

    /**
     * @param mixed $arrozSSL
     */
    public function setArrozSSL($arrozSSL)
    {
        $this->arrozSSL = $arrozSSL;
    }

    /**
     * @return mixed
     */
    public function getArrozSSL()
    {
        return $this->arrozSSL;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $servicioSecado
     */
    public function setServicioSecado($servicioSecado)
    {
        $this->servicioSecado = $servicioSecado;
    }

    /**
     * @return mixed
     */
    public function getServicioSecado()
    {
        return $this->servicioSecado;
    }

    /**
     * @param mixed $cantidadBasura
     */
    public function setCantidadBasura($cantidadBasura)
    {
        $this->cantidadBasura = $cantidadBasura;
    }

    /**
     * @return mixed
     */
    public function getCantidadBasura()
    {
        return $this->cantidadBasura;
    }

    /**
     * @param mixed $cantidadBlanco
     */
    public function setCantidadBlanco($cantidadBlanco)
    {
        $this->cantidadBlanco = $cantidadBlanco;
    }

    /**
     * @return mixed
     */
    public function getCantidadBlanco()
    {
        return $this->cantidadBlanco;
    }

    /**
     * @param mixed $cantidadEntero
     */
    public function setCantidadEntero($cantidadEntero)
    {
        $this->cantidadEntero = $cantidadEntero;
    }

    /**
     * @return mixed
     */
    public function getCantidadEntero()
    {
        return $this->cantidadEntero;
    }

    /**
     * @param mixed $cantidadHumedad
     */
    public function setCantidadHumedad($cantidadHumedad)
    {
        $this->cantidadHumedad = $cantidadHumedad;
    }

    /**
     * @return mixed
     */
    public function getCantidadHumedad()
    {
        return $this->cantidadHumedad;
    }

    /**
     * @param mixed $cantidadManchados
     */
    public function setCantidadManchados($cantidadManchados)
    {
        $this->cantidadManchados = $cantidadManchados;
    }

    /**
     * @return mixed
     */
    public function getCantidadManchados()
    {
        return $this->cantidadManchados;
    }

    /**
     * @param mixed $cantidadRojo
     */
    public function setCantidadRojo($cantidadRojo)
    {
        $this->cantidadRojo = $cantidadRojo;
    }

    /**
     * @return mixed
     */
    public function getCantidadRojo()
    {
        return $this->cantidadRojo;
    }

    /**
     * @param mixed $cantidadVerde
     */
    public function setCantidadVerde($cantidadVerde)
    {
        $this->cantidadVerde = $cantidadVerde;
    }

    /**
     * @return mixed
     */
    public function getCantidadVerde()
    {
        return $this->cantidadVerde;
    }

    /**
     * @param mixed $cantidadYeso
     */
    public function setCantidadYeso($cantidadYeso)
    {
        $this->cantidadYeso = $cantidadYeso;
    }

    /**
     * @return mixed
     */
    public function getCantidadYeso()
    {
        return $this->cantidadYeso;
    }

    /**
     * @param mixed $arrozNeto
     */
    public function setArrozNeto($arrozNeto)
    {
        $this->arrozNeto = $arrozNeto;
    }

    /**
     * @return mixed
     */
    public function getArrozNeto()
    {
        return $this->arrozNeto;
    }

    /**
     * @param mixed $productor
     */
    public function setProductor($productor)
    {
        $this->productor = $productor;
    }

    /**
     * @return mixed
     */
    public function getProductor()
    {
        return $this->productor;
    }



} 