<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 2/02/14
 * Time: 12:20
 */

namespace Sigza\CoreBundle\Entity;


use Doctrine\ORM\EntityRepository;

class ResultadosRepository extends CommonCRUDRepository{

    public function netosTotales(array $filtros){
        $remito = $filtros["remito"];
        $fi = $filtros["fi"];
        $ff = $filtros["ff"];
        $estado = $filtros["estado"];
        $productor = $filtros["productor"];
        $matricula = $filtros["matricula"];
        $planta = $filtros["planta"];

        $query = $this->_em->createQueryBuilder();
        $query->select( "SUM(re.arrozNeto) as ch" )->from($this->_entityName,"re");
        $query->innerJoin("re.id","r");

        if($matricula != null){
            $query->innerJoin("r.camion","c");
        }


        $query->where(" r.id is not null AND r.pesoSalida is not null ");

        if($remito != null){
            $query->andWhere(" LOWER(r.remito) =:remito ");
            $query->setParameter("remito",strtolower($remito));
        }

        if($fi != null){
            $query->andWhere(" r.fechaEntrada >= :fi  ");
            $query->setParameter("fi",$fi);
        }

        if($ff != null){
            $query->andWhere(" r.fechaEntrada <= :ff  ");
            $query->setParameter("ff",$ff);
        }

        if($estado != -1){
            if($estado == 1)
                $query->andWhere(" r.cerrado =:estado OR r.cerrado is null ");
            else
                $query->andWhere(" r.cerrado =:estado ");
            $query->setParameter("estado",($estado != 1));
        }

        if($productor != null){
            $query->andWhere(" r.productor =:productor  ");
            $query->setParameter("productor",$productor);
        }

        if($matricula != null){
            $query->andWhere(" c.matricula =:matricula  ");
            $query->setParameter("matricula",$matricula);
        }

        if($planta){
            $query->andWhere(" r.planta =:planta  ");
            $query->setParameter("planta",$planta);
        }
        $ch = $query->getQuery()->getResult();
        $ch = $ch[0];
        $ch1 = $ch["ch"];
        return $ch1;
    }


} 