<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 22/01/14
 * Time: 16:50
 */

namespace Sigza\CoreBundle\Entity;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Table(name="tipo_documentos")
 * @ORM\Entity(repositoryClass="TipoDocumentosRepository")
 */
class TipoDocumentos {
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @ORM\Column(type="string", length=150)
     * @Assert\NotBlank(message="Introduzca el dato")
     */
    protected $nombre;

    /**
     * @ORM\OneToMany(targetEntity="Productor",mappedBy="tipo_documentos")
     */
    protected $productor;

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $nombre
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    }

    /**
     * @return mixed
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * @param mixed $productor
     */
    public function setProductor($productor)
    {
        $this->productor = $productor;
    }

    /**
     * @return mixed
     */
    public function getProductor()
    {
        return $this->productor;
    }


} 