<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 22/01/14
 * Time: 16:38
 */

namespace Sigza\CoreBundle\Entity;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;


/**
 * @ORM\Table(name="tolerancia")
 * @ORM\Entity(repositoryClass="ToleranciaRepository")
 */
class Tolerancia {

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     * @Assert\Range(min=0, minMessage="Este valor debe ser positivo",
     * max=100, maxMessage="Este valor no debe exceder 100",
     * invalidMessage="Debe introducir valor numérico")
     */
    protected $humedad;

    /**
     * @ORM\Column(type="decimal", scale=2, name="verde", nullable=true)
     */
    protected $verde;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $basura;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $quebrado;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $yeso;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $rojo;

    /**
     * @ORM\Column(type="decimal", scale=2, nullable=true)
     */
    protected $mancha;

    /**
     * @ORM\ManyToOne(targetEntity="Productor", inversedBy="registro")
     * @ORM\JoinColumn(name="productor", referencedColumnName= "id")
     */
    protected $productor;

    public function setBasura($basura)
    {
        $this->basura = $basura;
    }

    public function getBasura()
    {
        return $this->basura;
    }

    public function setHumedad($humedad)
    {
        $this->humedad = $humedad;
    }

    public function getHumedad()
    {
        return $this->humedad;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function getId()
    {
        return $this->id;
    }

    public function setMancha($mancha)
    {
        $this->mancha = $mancha;
    }

    public function getMancha()
    {
        return $this->mancha;
    }

    public function setQuebrado($quebrado)
    {
        $this->quebrado = $quebrado;
    }

    public function getQuebrado()
    {
        return $this->quebrado;
    }

    public function setRojo($rojo)
    {
        $this->rojo = $rojo;
    }

    public function getRojo()
    {
        return $this->rojo;
    }

    public function setVerde($verde)
    {
        $this->verde = $verde;
    }

    public function getVerde()
    {
        return $this->verde;
    }

    public function setYeso($yeso)
    {
        $this->yeso = $yeso;
    }

    public function getYeso()
    {
        return $this->yeso;
    }

    public function setProductor($productor)
    {
        $this->productor = $productor;
    }

    public function getProductor()
    {
        return $this->productor;
    }




} 