<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 22/01/14
 * Time: 16:57
 */

namespace Sigza\CoreBundle\Entity;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
/**
 * @UniqueEntity(fields="usuario",message="El usuario ya está asignado")
 * @ORM\Table(name="usuario")
 * @ORM\Entity(repositoryClass="UsuarioRepository")
 */

class Usuario implements UserInterface{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @ORM\Column(type="string")
     * @Assert\NotBlank(message="El usuario no puede estar en blanco")
     */
    protected $usuario;

    /**
     * @ORM\Column(type="string")
     * @Assert\NotBlank(message="La contraseña no puede estar en blanco")
     */
    protected $password;

    /**
     * @ORM\Column(type="integer")
     */
    protected $tipo;

    /**
     * @ORM\Column(type="integer")
     */
    protected $referencia;

    /**
     * @ORM\Column(type="boolean")
     */
    protected $disabled;

    /**
     * @ORM\ManyToMany(targetEntity="Rol")
     * @ORM\JoinTable(name="rol_usuario",joinColumns={@ORM\JoinColumn(name="usuario", referencedColumnName="id")},
     * inverseJoinColumns={@ORM\JoinColumn(name="rol", referencedColumnName="id")})
     */
    protected $roles;

    private $detalles;

    /**
     * @ORM\ManyToOne(targetEntity="Planta")
     * @ORM\JoinColumn(name="planta", referencedColumnName= "id")
     */
    protected $planta;


    public function setId($id)
    {
        $this->id = $id;
    }

    public function getId()
    {
        return $this->id;
    }



    public function setPassword($password)
    {
        $this->password = $password;
    }

    public function getPassword()
    {
        return $this->password;
    }




    /**
     * Returns the roles granted to the user.
     *
     * <code>
     * public function getRoles()
     * {
     *     return array('ROLE_USER');
     * }
     * </code>
     *
     * Alternatively, the roles might be stored on a ``roles`` property,
     * and populated in any number of different ways when the user object
     * is created.
     *
     * @return Role[] The user roles
     */
    public function getRoles()
    {

        if($this->disabled == true)
            return array();

      $roles = array();
      for($i = 0; $i < count($this->roles); $i++)
          array_push($roles, $this->roles[$i]->getNombre());



        return $roles;
    }

    public function getRolesObjects()
    {
        return $this->roles;
    }



    public function setRoles($roles)
    {
        $this->roles = $roles;
    }

    public function setUsuario($usuario)
    {
        $this->usuario = $usuario;
    }



    public function getUsuario()
    {
        return $this->usuario;
    }

    /**
     * Returns the salt that was originally used to encode the password.
     *
     * This can return null if the password was not encoded using a salt.
     *
     * @return string|null The salt
     */
    public function getSalt()
    {
        return false;
    }

    /**
     * Returns the username used to authenticate the user.
     *
     * @return string The username
     */
    public function getUsername()
    {
        return $this->usuario;
    }

    /**
     * Removes sensitive data from the user.
     *
     * This is important if, at any given point, sensitive information like
     * the plain-text password is stored on this object.
     */
    public function eraseCredentials()
    {
        return false;
    }

    public function hasRol($id)
    {
        foreach ($this->roles as $r) {
            if($r->getId() == $id)
                return true;
        }
        return false;
    }

    public function setReferencia($referencia)
    {
        $this->referencia = $referencia;
    }

    public function getReferencia()
    {
        return $this->referencia;
    }

    public function setTipo($tipo)
    {
        $this->tipo = $tipo;
    }

    public function getTipo()
    {
        return $this->tipo;
    }

    public function setDisabled($disabled)
    {
        $this->disabled = $disabled;
    }

    public function getDisabled()
    {
        return $this->disabled;
    }

    public function setDetalles($detalles)
    {
        $this->detalles = $detalles;
    }

    public function getDetalles()
    {
        return $this->detalles;
    }

    public function setPlanta($planta)
    {
        $this->planta = $planta;
    }

    public function getPlanta()
    {
        return $this->planta;
    }

    public function getNombreCompleto(){
        if($this->detalles){
            if($this->getTipo() == 1){
                return $this->detalles->getNombre().' '.$this->detalles->getApellidos();
            }
            if($this->getTipo() == 2){
                return $this->detalles->getNombre();
            }
        }
        return "-";
    }




}