<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 22/01/14
 * Time: 17:16
 */

namespace Sigza\CoreBundle\Entity;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Table(name="variedad")
 * @ORM\Entity(repositoryClass="VariedadRepository")
 */

class Variedad {
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @ORM\Column(type="string", length=150)
     * @Assert\NotBlank(message="El nombre no puede estar en blanco")
     */
    protected $nombre;

    /**
     * @ORM\OneToMany(targetEntity="Parametros",mappedBy="variedad")
     */
    protected $parametros;

    /**
     * @ORM\OneToMany(targetEntity="Registro",mappedBy="variedad")
     */
    protected $registro;

    /**
     * @param mixed $registro
     */
    public function setRegistro($registro)
    {
        $this->registro = $registro;
    }

    /**
     * @return mixed
     */
    public function getRegistro()
    {
        return $this->registro;
    }


    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $nombre
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    }

    /**
     * @return mixed
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * @param mixed $parametros
     */
    public function setParametros($parametros)
    {
        $this->parametros = $parametros;
    }

    /**
     * @return mixed
     */
    public function getParametros()
    {
        return $this->parametros;
    }


} 