<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 24/01/14
 * Time: 17:13
 */

namespace Sigza\CoreBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
class RegistroType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder

            ->add('planta','entity',array('label'=>'Planta','class' => 'CoreBundle:Planta','property' => 'nombre'))
            ->add('camion','entity',array('label'=>'Matrícula Camión:','class' => 'CoreBundle:Camion','property' => 'matricula'))
            ->add('fechaEntrada','date',array('label'=>'Fecha de Entrada:','widget'=>'single_text','required'=>true, 'attr'=>array('placeholder'=>'d / M / yyyy'),'format'=>'dd/MM/yyyy','input'=>'datetime'))
            ->add('horaEntrada','time',array('label'=>'Hora de Entrada:','widget'=>'single_text','required'=>true, 'attr'=>array('placeholder'=>'H:m'),'input'=>'datetime'))

            ->add('remito','text',array('label'=>'No. Remito:'))
            ->add('remitoProductor','text',array('label'=>'Remito Productor:','required'=>false))
            ->add('productor','entity',array('label'=>'Nombre Productor:','class' => 'CoreBundle:Productor','property' => 'nombre','required'=>false))
            ->add('chacra','entity',array('label'=>'Chacra:','class' => 'CoreBundle:Chacra','property' => 'nombre','required'=>false))
            ->add('pesoEntrada', 'text', array('label'=>'Peso Entrada:'))
            ->add('producto','entity',array('label'=>'Producto:','class' => 'CoreBundle:Producto','property' => 'nombre'))
            ->add('variedad','entity',array('label'=>'Variedad:','class' => 'CoreBundle:Variedad','property' => 'nombre','required'=>false))
            ->add('origenDestino','entity',array('label'=>'Origen / Destino:','class' => 'CoreBundle:OrigenDestino','property' => 'nombre'))

            // Actualizacion entrada del parametro humedad
            ->add('humedad', 'decimal_type', array('label'=>'Humedad:','required'=>false))

            // Actualizacion salida del camion
            ->add('fechaSalida','date',array('label'=>'Fecha de Salida:','widget'=>'single_text','required'=>false, 'attr'=>array('placeholder'=>'d / M / yyyy'),'format'=>'dd/MM/yyyy','input'=>'datetime'))
            ->add('horaSalida','time',array('label'=>'Hora de Salida:','widget'=>'single_text','required'=>false, 'attr'=>array('placeholder'=>'H:m'),'input'=>'datetime'))
            ->add('pesoSalida', 'text', array('label'=>'Peso Salida:','required'=>false))
            ->add('observacion','textarea',array('label'=>'Observaciones:','required'=>false))
        ;
    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Sigza\CoreBundle\Entity\Registro'
        ));
    }

    public function getName()
    {
        return 'registro';
    }

} 