<?php
/**
 * Created by JetBrains PhpStorm.
 * User: maikel
 * Date: 26/07/13
 * Time: 19:51
 * To change this template use File | Settings | File Templates.
 */

namespace Sigza\CoreBundle\Form\Type;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Sigza\CoreBundle\Form\DataTransformer\DecimalToStringTransformer;

class DecimalType extends AbstractType {

    /**
     * Returns the name of this type.
     *
     * @return string The name of this type
     */
    public function getName()
    {
       return "decimal_type";
    }

    public function getParent()
    {
        return "text";
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $transformer = new DecimalToStringTransformer();
        $builder->addModelTransformer($transformer);
    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'attr' => array("pattern"=>"^([0-9]+)((\.)[0-9]+)?$",'title'=>'Valor porcentual', 'class'=>'porciento')
        ));
    }


}