<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 23/01/14
 * Time: 17:24
 */

namespace Sigza\CoreBundle\Service;
/**
 * Created by JetBrains PhpStorm.
 * User: Maikel Pérez Martínez <kalafyan@gmail.com>
 * Date: 26/05/13
 * Time: 19:14
 * To change this template use File | Settings | File Templates.
 */
abstract class BaseService
{
    /**
     * @var \Doctrine\ORM\EntityManager
     */
    protected $em;


    /** Persistir entidad Obj haciendo o no flush
     * @param $obj
     * @param $flush
     */
    public function save($obj, $flush)
    {
        $this->em->persist($obj);
        if ($flush)
            $this->em->flush();
    }

    public function saveOrUpdate($entity, $id, $flush){
        if($id == null || $id == '')
            $this->save($entity,$flush);
        else
            $this->update($entity,$flush);
    }

    public function update($obj, $flush){
        $this->em->merge($obj);
        if ($flush)
            $this->em->flush();
    }

    /** Remove sobre la entidad Obj haciendo o no flush
     * @param $obj
     * @param $flush
     */
    public function delete($obj, $flush)
    {
        $this->em->remove($obj);
        if ($flush)
            $this->em->flush();
    }

    /**
     * Realizar flush
     */
    public function flush()
    {
        $this->em->flush();
    }

    /**
     * Setear el entity manager
     * @param $em
     */
    public function setEm($em){
        $this->em = $em;
    }

    /** Obtener la referencia a un repositorio del bundle
     * @param $name
     * @return \Doctrine\ORM\EntityRepository
     */
    public function getRepository($name){
        return $this->em->getRepository("CoreBundle:".$name);
    }

    /**
     * @param $className
     * @return \Doctrine\ORM\EntityRepository
     */
    protected function repo($className){
        return $this->getRepository($className);
    }


    /**
     * Metodo de carga inicial para resolver las referencias a los repos del service
     */
    public function initRepos(){

    }

    protected $logger;
    public function setLogger($logger){
        $this->logger = $logger;
    }

    protected function writeInfo($info){
        $this->logger->info($info);
    }
}
