<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Maikel
 * Date: 2/9/14
 * Time: 2:02 AM
 * To change this template use File | Settings | File Templates.
 */

namespace Sigza\CoreBundle\Service;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Security\Core\Authorization\Voter\VoterInterface;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;

class ClientIpVoter implements VoterInterface
{
    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }
    public function supportsAttribute($attribute)
    {
// you won't check against a user attribute, so return true
        return true;
    }
    public function supportsClass($class)
    {
// your voter supports all type of token classes, so return true
        return true;
    }
    function vote(TokenInterface $token, $object, array $attributes)
    {


        $request = $this->container->get('request');
        if(!$this->container->get('security.context')->getToken()->getRoles())
            return VoterInterface::ACCESS_ABSTAIN;

        $user = $this->container->get('security.context')->getToken()->getUser();

        if($user->getUsername() == 'root'){
            return VoterInterface::ACCESS_ABSTAIN;
        }

        if($user->getDisabled() == true){
            return VoterInterface::ACCESS_DENIED;
        }

        if($user->getTipo() == 2){
            return VoterInterface::ACCESS_ABSTAIN;
        }

        return VoterInterface::ACCESS_ABSTAIN;

        $ipPlantaActual = $request->getClientIp();
        $posiblesPlantas = array();

        $em = $this->container->get("doctrine")->getManager();
        $posiblesPlantas = $em->getRepository("CoreBundle:Planta")->porIp($ipPlantaActual);

        if(!count($posiblesPlantas)){
            return VoterInterface::ACCESS_DENIED;
        }

        $plantaUser = $user->getPlanta();

        for($i = 0; $i < count($posiblesPlantas); $i++)
            if($posiblesPlantas[$i]->getId() == $plantaUser->getId()){
                return VoterInterface::ACCESS_ABSTAIN;
            }

        return VoterInterface::ACCESS_DENIED;
    }
}