<?php
/**
 * Created by JetBrains PhpStorm.
 * User: maikel
 * Date: 15/07/13
 * Time: 14:16
 * To change this template use File | Settings | File Templates.
 */

namespace Sigza\CoreBundle\Service;


class MailerService{
    private $mailer;
    private $logger;
	private $sender;



    public function sendMail(array $options){
        $message = \Swift_Message::newInstance()
            ->setSubject($options['subject'])
            ->setTo($options['to'])
			->setFrom($this->sender)
            ->setBody(
                $options['body'] , "text/html"
            )

        ;
        try{
        $this->mailer->send($message);
        }catch (\Exception $e){
            $this->logger->info($e->getTraceAsString());
        }
    }

    public function sendMails(array $options){

        for ($i = 0; $i < count($options); $i++) {
            $op = $options[$i];
            $message = \Swift_Message::newInstance()
                ->setSubject($op['subject'])
                ->setTo($op['to'])
				->setFrom($this->sender)
                ->setBody(
                    $op['body'],"text/html"
                );
            try {
                $this->mailer->send($message);
                $this->logger->info("Mensaje enviado");
            } catch (\Exception $e) {
                $this->logger->info($e->getTraceAsString());
            }
        }
    }

    public function getMailer()
    {
        return $this->mailer;
    }

    

	public function setSender($sender){
		$this->sender = $sender;
	}

    public function setMailer($mailer)
    {
        $this->mailer = $mailer;
    }

    public function setLogger($logger){
        $this->logger = $logger;
    }
}