<?php

namespace Sigza\LaboratorioBundle\Controller;

use Sigza\CoreBundle\Controller\CommonController;
use Sigza\CoreBundle\Form\LaboratorioType;
use Sigza\CoreBundle\Entity\Parametros;

class DefaultController extends CommonController
{
    public function indexAction($id)
    {
        $registro = $this->coreService()->buscarRegistroPorId($id);
        $parametros = $this->coreService()->buscarParametrosPorId($id);
        $granoEntero = 0;
        if(  ($parametros->getQuebrado()==null) &&  ($parametros->getBaseBlanco() != null) && ($parametros->getGranoEntero() != null)){
            $granoEntero = $parametros->getBaseBlanco() - $parametros->getGranoEntero();
            $parametros->setQuebrado($granoEntero);
        }

        if($parametros == null){
            $parametros = new Parametros();
            $parametros->setId($registro);
            $parametros->setHumedad($registro->getHumedad());
            $parametros->setVariedad($registro->getVariedad());
        }
        if($registro->getHumedad()){
            $parametros->setHumedad($registro->getHumedad());
        }
        if($registro->getVariedad()){
            $parametros->setVariedad($registro->getVariedad());
        }

        $form = $this->createForm(new LaboratorioType(),$parametros);

        if($this->isPost()){
            $form->submit($this->getRequest());
            if($form->isValid()){
                if($this->coreService()->labCerrado($parametros->getId()->getRemito())){
                    $parametros->setCerrado(true);
                    $fecha = $parametros->getId()->getFechaSalida();
                    if($fecha != null){
                        $this->coreService()->actualizarResultados($registro);
                        if($registro->getProductor()->getNotificacionRemitoCerrado())
                            $this->get('sigza.mailer')->sendMail(array('subject' => 'Remito cerrado', 'to' =>
                            $registro->getProductor()->getEmail(), 'body' => $this->productorEmailTotales($registro)));
                    }
                }
                if(!$parametros->getUsuario())
                    $parametros->setUsuario($this->getUser()->getId());
                $this->coreService()->saveOrUpdate($parametros, $parametros->getId(), true);
                return $this->redirect($this->generateUrl("laboratorio_buscar"));
            }
        }
        return $this->render('LaboratorioBundle:Default:laboratorio.html.twig', array(
            "form"          => $form->createView(),
            "registro"      => $registro,
            "parametros"    => $parametros
        ));
    }

    public function buscarAction()
    {
        $remito = null;
        $entities = array();
        $estados = array();
        $pagerHtml = null;
        $planta = $this->getUser()->getPlanta();
        $resultados = array();
        $totalChacra = 0;

        if($this->isPost()){
            $page = $this->getParam("page");
            if(!$page)
                $page = 1;
            $remito = $this->getParam("remito");
            $queryBuilder = $this->coreService()->buscarRegistrosPorRemitoQuery($remito, $planta);
            $chacraTotal = $this->coreService()->totalChacra($remito, $planta);
            $totalChacra = number_format($chacraTotal, 2, '.', ',');
            list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"laboratorio_buscar");
            for($i = 0;$i < count($entities); $i++){
                $r = $entities[$i];
                $p = $this->coreService()->labCerrado($r->getRemito());
                if($p == true){
                    $e = 1; //  carrado
                }else
                    $e = 2; // abierto
                $estados[$r->getRemito()] = $e;
                $resultados[$r->getRemito()] = $this->coreService()->CRUDBuscarPorId("Resultados",$r->getId());
                $chacra = $resultados[$r->getRemito()]->getArrozChacra();
                $arrozChacra[$r->getRemito()] = number_format($chacra, 2, '.', ',');
            }
        }
        else{
            $page = $this->getParam("page");
            if(!$page)
                $page = 1;
            $remito = "";
            $queryBuilder = $this->coreService()->buscarRegistrosPorRemitoQuery($remito, $planta);
            $chacra = $this->coreService()->totalChacra($remito, $planta);
            $totalChacra = number_format($chacra, 2, '.', ',');
            list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"laboratorio_buscar");
            for($i = 0;$i < count($entities); $i++){
                $r = $entities[$i];
                $p = $this->coreService()->labCerrado($r->getRemito());
                if($p == true){
                    $e = 1; //  carrado
                }else
                    $e = 2; // abierto
                $estados[$r->getRemito()] = $e;
                $resultados[$r->getRemito()] = $this->coreService()->CRUDBuscarPorId("Resultados",$r->getId());
                $chacra = $resultados[$r->getRemito()]->getArrozChacra();
                $arrozChacra[$r->getRemito()] = number_format($chacra, 2, '.', ',');
            }
        }
        return $this->render('LaboratorioBundle:Default:buscar.html.twig', array(
            "remito" => $remito,
            "registros" => $entities,
            "estados"   => $estados,
            'pagerHtml' => $pagerHtml,
            'resultados'=>$resultados,
            "arrozChacra" => $arrozChacra,
            'totalChacra'=>$totalChacra,
        ));
    }

    public function buscarMovilAction()
    {
        $remito = null;
        $registros = array();
        $estados = array();

        if($this->isPost()){
            $remito = $this->getParam("remito");
            $registros = $this->coreService()->buscarRegistrosPorRemito($remito);
            for($i = 0;$i < count($registros); $i++){
                $r = $registros[$i];
                $p = $this->coreService()->labCerrado($r->getRemito());
                if($p == true){
                    $e = 1; //  carrado
                }else
                    $e = 2; // abierto
                $estados[$r->getRemito()] = $e;
            }
        }
        return $this->render('LaboratorioBundle:Default:buscarMovil.html.twig', array(
            "remito" => $remito,
            "registros" => $registros,
            "estados"   => $estados
        ));
    }

    public function listarAction(){

        $entities = array();
        $pagerHtml = null;
        $planta = $this->getUser()->getPlanta();

        $remito = $this->getParam("remito");
        $fi = $this->getParam("fi");
        $ff = $this->getParam("ff");
        $estado = $this->getParam("estado");
        $filtros = array();
        $filtros["remito"] = $remito ? $remito : null ;
        $filtros["fi"] = $fi ? date_create_from_format("d/m/Y",$fi) : null ;
        $filtros["ff"] = $ff ? date_create_from_format("d/m/Y",$ff) : null ;
        $filtros["estado"] = $estado ? $estado : -1 ;

        $page = $this->getParam("page");
        if(!$page)
            $page = 1;
        $queryBuilder = $this->coreService()->listarParametrosFiltroQuery($filtros, $planta);
        list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"laboratorio_listar");

        return $this->render('LaboratorioBundle:Default:listar.html.twig', array(
            "parametros" => $entities,
            "remito"=>$remito,
            "fi"=>$fi,
            "ff"=>$ff,
            "estado"=>$estado,
            'pagerHtml' => $pagerHtml,
        ));
    }

    public function listarMovilAction(){

        $parametros = array();

        $remito = $this->getParam("remito");
        $fi = $this->getParam("fi");
        $ff = $this->getParam("ff");
        $estado = $this->getParam("estado");
        $filtros = array();
        $filtros["remito"] = $remito ? $remito : null ;
        $filtros["fi"] = $fi ? date_create_from_format("d/m/Y",$fi) : null ;
        $filtros["ff"] = $ff ? date_create_from_format("d/m/Y",$ff) : null ;
        $filtros["estado"] = $estado ? $estado : -1 ;

        $parametros = $this->coreService()->listarParametrosFiltro($filtros);

        return $this->render('LaboratorioBundle:Default:listarMovil.html.twig', array(
            "parametros" => $parametros,
            "remito"=>$remito,
            "fi"=>$fi,
            "ff"=>$ff,
            "estado"=>$estado
        ));
    }
}
