<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 28/01/14
 * Time: 22:01
 */

namespace Sigza\AdminBundle\Controller;
use Symfony\Component\HttpFoundation\Request;
use Sigza\CoreBundle\Entity as entities;
class BaseController extends AdminCrudController{

    function __construct()
    {
        $this->entityName = "Base";
        $this->notFoundMessage = "No se pudo encontrar la base solicitada";
        $this->sigle = "Bases de comercialización";
        $this->plural = "Bases";
    }
//grano_entero_variedad_
    public function newAction()
    {
        $productor = $this->getParam("_p");
        $e_ = $this->coreService()->baseProductor($productor!=null?$productor:null);
        if($e_ != null){
            return $this->redirect($this->generateUrl($this->entityName.'_edit', array('id' => $e_->getId(),'retorno'=>$this->getParam("retorno"))));
        }
        $entity = $this->buildEntity();
        $p = null;
        if($productor != null){
            $p = $this->coreService()->CRUDBuscarPorId("Productor",$productor);
            $entity->setProductor($p);
        }
        $form = $this->buildType($entity);
        return $this->render($this->bundleName.":".$this->entityName.":new.html.twig", array(
            'entity' => $entity,
            'form'   => $form->createView(),
            'entityName' => $this->entityName,
            'title'=>"Crear ".$this->sigle.($p != null ? " para ".$p->getNombre() : ""),
            'retorno'=>$this->getParam("retorno"),
            'bundleName'=>$this->bundleName,
            'retorno'=>$this->getParam("retorno"),
            'variedades'=>$this->coreService()->CRUDlistar("Variedad")
        ));
    }

    public function createAction(Request $request)
    {
        $entity = $this->buildEntity();
        $form = $this->buildType($entity);
        $form->submit($request);
        $retorno = $this->getParam("retorno");
        if ($form->isValid()) {
            $variedades = $this->coreService()->CRUDlistar("Variedad");
            $granosEnteros = array();
            for($i = 0; $i < count($variedades); $i++ ){
                $v = $this->getParam("grano_entero_variedad_" . $variedades[$i]->getId());
                if ($v != null) {
                    $granoEntero = new entities\BaseGranoEnteroVariedad();
                    $granoEntero->setBase($entity);
                    $granoEntero->setVariedad($variedades[$i]);
                    $granoEntero->setValor($v);
                    array_push($granosEnteros, $granoEntero);
                }
            }
            $entity->setGranoEntero($granosEnteros);
            $this->save($entity);
            if($retorno == null || $retorno == '')
                return $this->redirect($this->generateUrl($this->entityName.'_edit', array('id' => $entity->getId())));

            $rs = str_getcsv($retorno,",");
            $r = $rs[ count($rs) - 1 ];
            $retorno = "";
            for($i = 0; $i < count($rs) - 1; $i++){
                if($i > 0)
                    $retorno.=',';
                $retorno.=$rs[$i];
            }


            return $this->redirect($this->generateUrl($r, array('id' => $entity->getId(),"retorno"=>$retorno)));
        }
        return $this->render($this->bundleName.":".$this->entityName.":new.html.twig", array(
            'entity' => $entity,
            'form'   => $form->createView(),
            'entityName' => $this->entityName,
            'title'=>"Crear ".$this->sigle.($entity->getProductor() != null ? " para ".$entity->getProductor()->getNombre() : ""),
            'retorno'=>$this->getParam("retorno"),
            'bundleName'=>$this->bundleName,
            'variedades'=>$this->coreService()->CRUDlistar("Variedad")
        ));
    }

    public function editAction($id)
    {
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        $editForm = $this->buildType($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render($this->bundleName.":".$this->entityName.":edit.html.twig", array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'entityName' => $this->entityName,
            'title'=>"Editar ".$this->sigle.($entity->getProductor() != null ? " para ".$entity->getProductor()->getNombre() : ""),
            'bundleName'=>$this->bundleName,
            'retorno'=>$this->getParam("retorno"),
            'variedades'=>$this->coreService()->CRUDlistar("Variedad")
        ));
    }

    public function updateAction(Request $request,$id)
    {
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->buildType($entity);
        $editForm->submit($request);
        $retorno = $this->getParam("retorno");

        if ($editForm->isValid()) {

            $variedadesSelf = $entity->getGranoEntero();
            $variedadesIn = array();
            for($i = 0; $i < count($variedadesSelf); $i++){
                $v = $this->getParam("grano_entero_variedad_" . $variedadesSelf[$i]->getVariedad()->getId());
                if ($v != null) {
                    $variedadesSelf[$i]->setValor($v);
                    $variedadesIn[$variedadesSelf[$i]->getVariedad()->getId()] = "OK";
                }
            }

            $variedades = $this->coreService()->CRUDlistar("Variedad");
            for($i = 0; $i < count($variedades); $i++ ){
                if (!array_key_exists($variedades[$i]->getId(), $variedadesIn)) {
                    $v = $this->getParam("grano_entero_variedad_" . $variedades[$i]->getId());
                    if ($v != null) {
                        $granoEntero = new entities\BaseGranoEnteroVariedad();
                        $granoEntero->setBase($entity);
                        $granoEntero->setVariedad($variedades[$i]);
                        $granoEntero->setValor($v);
                        $entity->addVariedad($granoEntero);
                    }
                }
            }
            $this->save($entity);
            if($retorno == null || $retorno == '')
                return $this->redirect($this->generateUrl($this->entityName.'_edit', array('id' => $id)));

            $rs = str_getcsv($retorno,",");
            $r = $rs[ count($rs) - 1 ];
            $retorno = "";
            for($i = 0; $i < count($rs) - 1; $i++){
                if($i > 0)
                    $retorno.=',';
                $retorno.=$rs[$i];
            }


            return $this->redirect($this->generateUrl($r, array('id' => $entity->getId(),"retorno"=>$retorno)));
        }

        return $this->render($this->bundleName.":".$this->entityName.":edit.html.twig", array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'entityName' => $this->entityName,
            'title'=>"Editar ".$this->sigle,
            'retorno'=>$retorno,
            'bundleName'=>$this->bundleName
        ));
    }
} 