<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Maikel
 * Date: 2/5/14
 * Time: 10:53 PM
 * To change this template use File | Settings | File Templates.
 */

namespace Sigza\AdminBundle\Controller;
use Sigza\AdminBundle\Controller\AdminCrudController;
use Symfony\Component\HttpFoundation\Request;
class ToleranciaController extends AdminCrudController{

    function __construct()
    {
        $this->entityName = "Tolerancia";
        $this->notFoundMessage = "No se pudo encontrar la tolerancia solicitada";
        $this->sigle = "Tolerancia al recibo";
        $this->plural = "Tolerancia al recibo";
    }

    public function newAction()
    {
        $productor = $this->getParam("_p");
        $e_ = $this->coreService()->toleranciaProductor($productor!=null?$productor:null);
        if($e_ != null){
            return $this->redirect($this->generateUrl($this->entityName.'_edit', array('id' => $e_->getId(),'retorno'=>$this->getParam("retorno"))));
        }
        $entity = $this->buildEntity();
        if($productor != null){
            $entity->setProductor($this->coreService()->CRUDBuscarPorId("Productor",$productor));
        }
        $form = $this->buildType($entity);
        return $this->render($this->bundleName.":".$this->entityName.":new.html.twig", array(
            'entity' => $entity,
            'form'   => $form->createView(),
            'entityName' => $this->entityName,
            'title'=>"Crear ".$this->sigle.($entity->getProductor() != null ? " para ".$entity->getProductor()->getNombre() : ""),
            'retorno'=>$this->getParam("retorno"),
            'bundleName'=>$this->bundleName,
        ));
    }

    public function editAction($id)
    {
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        $editForm = $this->buildType($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render($this->bundleName.":".$this->entityName.":edit.html.twig", array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'entityName' => $this->entityName,
            'title'=>"Editar ".$this->sigle.($entity->getProductor() != null ? " para ".$entity->getProductor()->getNombre() : ""),
            'retorno'=>$this->getParam("retorno"),
            'bundleName'=>$this->bundleName
        ));
    }

    public function createAction(Request $request)
    {
        $entity = $this->buildEntity();
        $form = $this->buildType($entity);
        $form->submit($request);
        $retorno = $this->getParam("retorno");
        if ($form->isValid()) {
            $this->save($entity);
            if($retorno == null || $retorno == '')
                return $this->redirect($this->generateUrl($this->entityName.'_edit', array('id' => $entity->getId())));

            $rs = str_getcsv($retorno,",");
            $r = $rs[ count($rs) - 1 ];
            $retorno = "";
            for($i = 0; $i < count($rs) - 1; $i++){
                if($i > 0)
                    $retorno.=',';
                $retorno.=$rs[$i];
            }


            return $this->redirect($this->generateUrl($r, array('id' => $entity->getId(),"retorno"=>$retorno)));
        }
        return $this->render($this->bundleName.":".$this->entityName.":new.html.twig", array(
            'entity' => $entity,
            'form'   => $form->createView(),
            'entityName' => $this->entityName,
            'title'=>"Crear ".$this->sigle.($entity->getProductor() != null ? " para ".$entity->getProductor()->getNombre() : ""),
            'retorno'=>$retorno
        ));
    }

    public function updateAction(Request $request,$id)
    {
        $entity = $this->buscarPorId($id);
        if (!$entity) {
            throw $this->createNotFoundException($this->notFoundMessage);
        }
        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->buildType($entity);
        $editForm->submit($request);
        $retorno = $this->getParam("retorno");

        if ($editForm->isValid()) {
            $this->save($entity);
            if($retorno == null || $retorno == '')
                return $this->redirect($this->generateUrl($this->entityName.'_edit', array('id' => $id)));

            $rs = str_getcsv($retorno,",");
            $r = $rs[ count($rs) - 1 ];
            $retorno = "";
            for($i = 0; $i < count($rs) - 1; $i++){
                if($i > 0)
                    $retorno.=',';
                $retorno.=$rs[$i];
            }


            return $this->redirect($this->generateUrl($r, array('id' => $entity->getId(),"retorno"=>$retorno)));
        }

        return $this->render($this->bundleName.":".$this->entityName.":edit.html.twig", array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
            'entityName' => $this->entityName,
            'title'=>"Editar ".$this->sigle.($entity->getProductor() != null ? " para ".$entity->getProductor()->getNombre() : ""),
            'bundleName'=>$this->bundleName,
            'retorno'=>$retorno
        ));
    }
}