<?php

namespace Sigza\CoreBundle\Controller;


use Sigza\CoreBundle\Entity\Parametros;
use Sigza\CoreBundle\Entity\Productor;
use Sigza\CoreBundle\Entity\Registro;
use Sigza\CoreBundle\Entity\Resultados;
use Sigza\CoreBundle\Entity\Usuario;
use Sigza\CoreBundle\Form\UsuarioType;
use Ps\PdfBundle\Annotation\Pdf;
use Symfony\Component\HttpFoundation\Response;
use PHPExcel_Shared_Date;
use PHPExcel_Style_NumberFormat;
use PHPExcel_IOFactory;
use PHPExcel_Style_Color;
class DefaultController extends CommonController
{

    public function userInfoAction($id, $tipo){
        $nombre = "";
        if($tipo && $id){
            $ref_ = $this->coreService()->CRUDBuscarPorId( ($tipo == 1 ? "Empleado" : "Productor"),$id) ;
            $nombre = $ref_ ->getNombre().( $tipo == 1 ? ' '. $ref_->getApellidos() : '' );

        }
        return $this->responseJSON("{\"nombre\":\"".$nombre."\"}");
    }

    public function chacrasProductorAction(){
        $id = $this->getParam("id");
        $chacras = "[";
        if($id){
            $chs = $this->coreService()->chacrasPorProductor($id)->getQuery()->getResult();
            for($i = 0; $i < count($chs); $i++){
                if($i > 0)
                    $this->putJSONString($chacras,",");
                $this->putJSONString($chacras,"{");
                $this->putJSONStringProp($chacras,"id",$chs[$i]->getId(),true);
                $this->putJSONStringProp($chacras,"nombre",$chs[$i]->getNombre(),false);
                $this->putJSONString($chacras,"}");
            }
        }
        $this->putJSONString($chacras,"]");
        return $this->responseJSON("{\"chacras\":".$chacras."}");
    }



    public function loginAction(){
        //if ($this->get('security.context')->isGranted('ROLE_CONSULTA_ADMIN') === true)
        //return $this->redirect($this->generateUrl('ap_homepage'));

        $form = $this->createForm(new UsuarioType(), new Usuario());
        return $this->render('CoreBundle::login.html.twig', array('form' => $form->createView(),'error'=>  $this->getRequest()->getSession()->get(\Symfony\Component\Security\Core\SecurityContext::AUTHENTICATION_ERROR)));
    }

    public function homeAction(){
        if($this->getUser())
            return $this->render('CoreBundle::index.html.twig');
        else
            return $this->redirect($this->generateUrl("login"));
    }

    public function registrarseAction(){
        return $this->render('CoreBundle:Default:registrarse.html.twig');
    }

    private function notEmpty($val){
        return $val != null && $val != '';
    }

    /**
     * @Pdf()
     */
    public function imprimirRemitosProdAction(){
        if($this->isPost()){
            $parametros = array();
            $estadoremito = 0;
            $usuario = $this->getUser();
            $tabla = $usuario->getTipo() == 1 ? "Empleado": "Productor";
            $referencia = $this->coreService()->CRUDBuscarPorId($tabla,$usuario->getReferencia());
            $nombreCompleto = $referencia ? $referencia->getNombreCompleto():$usuario->getUsuario();

            $fechaImpresion = new \DateTime('now');

            $format = $this->get('request')->get('_format');

            $remito = $this->getParam("remito");
            $fi = $this->getParam("fi");
            $ff = $this->getParam("ff");
            $matricula = $this->getParam("matricula");
            $estado = $this->getParam("estado");
            $remitoProductor = $this->getParam("remitoProductor");
            $productores = $this->coreService()->CRUDlistar("Productor");
            //Nuevos filtros
            $variedades = $this->coreService()->CRUDlistar("Variedad");
            $chacras = $this->coreService()->CRUDlistar("Chacra");
            $variedad = $this->getParam("variedad");
            $chacra = $this->getParam("chacra");
            $empresas = $this->coreService()->CRUDlistar("Empresa");
            $empresa = $this->getParam("empresa");


            $filtros = array();
            $filtros["remito"] = $remito ? $remito : null ;
            $filtros["fi"] = $this->notEmpty($fi)  ? date_create_from_format("d/m/Y",$fi) : null ;
            $filtros["ff"] = $this->notEmpty($ff)  ? date_create_from_format("d/m/Y",$ff) : null ;
            $filtros["matricula"] = $matricula ? $matricula : null ;
            $filtros["estado"] = $estado ? $estado : -1 ;
            //Nuevos Filtros
            $filtros["remitoProductor"] = $remitoProductor ? $remitoProductor : null ;
            $filtros["variedad"] = $variedad && $variedad != -1 ? $variedad : null;
            $filtros["chacra"] = $chacra && $chacra != -1 ? $chacra : null;
            $filtros["empresa"] = $empresa && $empresa != -1 ? $empresa : null;
            $chacraTotal = 0;
            $netoTotal = 0;
            $productor = null;
            if($usuario->getTipo() == 2){
                $productor = $usuario->getReferencia();
                $filtros["productor"] = $productor ? $productor : null;
                //$chacras = $this->coreService()->chacrasPorProductor($productor)->getQuery()->getResult();
            }

            $admin = $productor == null ? 1 : 0;
            if($admin == 1){
                $productor = $this->getParam("productor");
                $productor = $productor == null || $productor == -1 ? null : $productor;
            }
            $filtros["planta"] = $admin == 1 ? $usuario->getPlanta() : null;
            $filtros["productor"] = $productor ? $productor : null;

            $entities = $this->coreService()->listarInfoProductorQuery($filtros)->getResult();
            $totales = $this->coreService()->totales($filtros);
            $chacraTotal = number_format($totales[0], 2, '.', ',');
            $netoTotal =  number_format($totales[1], 2, '.', ',');

            $data = array();
            for($i =0; $i<count($entities);$i++){
                $dataRemito = array();
                /**
                 * @var Registro $r
                 */
                $r = $entities[$i];
                $cerrado = $r->getCerrado();

                if ($cerrado == null || $cerrado == false)
                    $estadoremito = -1;
                else
                    $estadoremito = 1;

                $dataRemito["id"]=$r->getId(); //Id en Registro
                $dataRemito["registro"]=$r;
                $dataRemito["remito"]=$r->getRemito();
                $dataRemito["estado"]=$estadoremito;
                $dataRemito["matricula"]=$r->getCamion()->getMatricula();
                if ($r->getPlanta()){
                    $dataRemito["planta"]=$r->getPlanta()->getNombre();
                }else{}

                $dataRemito["fechaEntrada"]=$r->getFechaEntrada();
                $dataRemito["Productor"]=$r->getProductor()->getNombre();
                if($r->getFechaSalida()== null)
                    $dataRemito["fechaSalida"]="";
                else
                    $dataRemito["fechaSalida"]=$r->getFechaSalida();

                $parametros = $this->coreService()->CRUDBuscarPorId("Parametros",$r->getId());
                if($parametros->getCerrado()){
                    $dataRemito["Cerrado"]= 1;
                }else{
                    $dataRemito["Cerrado"]= -1;
                }
                /**
                 * @var Resultados $resultados
                 */
                $resultados = $this->coreService()->CRUDBuscarPorId("Resultados",$r->getId());//resultados por registro

                if($resultados->getArrozChacra() == null){
                    $dataRemito["Chacra"]="-";
                }else{
                    $dataRemito["Chacra"]=number_format($resultados->getArrozChacra(), 2, '.', ',');
                }
                if($resultados->getArrozNeto() == null){

                    $dataRemito["Neto"]="-";
                }else{
                    $dataRemito["Neto"]=number_format($resultados->getArrozNeto(), 2, '.', ',');
                }
                array_push($data,$dataRemito);
            }

            $response = $this->render(sprintf('CoreBundle:Default:print_remitos_productor.%s.twig', $format), array(
                "data"=>$data,
                "fi"=>$fi,
                "ff"=>$ff,
                "remito"=>$remito,
                "matricula"=>$matricula,
                "estado"=>$estado,
                "admin"=>$admin,
                "productores"=>$productores,
                "productor"=>$productor == null ? -1 : $productor,
                'chacraTotal'=>$chacraTotal,
                'netoTotal'=>$netoTotal,
                "remitoProductor"=>$remitoProductor,
                "variedades"=>$variedades,
                "variedad"=>$variedad == null ? -1 : $variedad,
                "chacras"=>$chacras,
                "chacra"=>$chacra == null ? -1 : $chacra,
                "empresas"=>$empresas,
                "empresa"=>$empresa == null ? -1 : $empresa,
                "usuario"=>$usuario,
                "fechaimpresion"=>$fechaImpresion,
                "nombrecompleto"=>$nombreCompleto,
            ));
            $response->headers->set("Content-Disposition","attachment; filename=\"reporte.pdf\"");
            return $response;

        }
        return $this->redirect($this->generateUrl("productor_remitos_listar"));
    }


    public function excelRemitosProductorAction(){
        if($this->isPost()){

            $parametros = array();
            $usuario = $this->getUser();
            $tabla= $usuario->getTipo() == 1 ? "Empleado": "Productor";
            // Para Productor buscar en tabla productor
            $referencia = $this->coreService()->CRUDBuscarPorId($tabla,$usuario->getReferencia());
            $nombreCompleto = $referencia ? $referencia->getNombreCompleto():$usuario->getUsuario();

            $entities = array();
            $entitiesResultados = array();
            $entitiesParametros = array();

            $r = array();
            $remito = null;

            $remito = $this->getParam("remito");
            $fi = $this->getParam("fi");
            $ff = $this->getParam("ff");
            $matricula = $this->getParam("matricula");
            $estado = $this->getParam("estado");
            $remitoProductor = $this->getParam("remitoProductor");
            //Nuevos filtros
            $variedad = $this->getParam("variedad");
            $chacra = $this->getParam("chacra");
            $empresa = $this->getParam("empresa");
            $filtros = array();
            $filtros["remito"] = $remito ? $remito : null ;
            $filtros["fi"] = $this->notEmpty($fi)  ? date_create_from_format("d/m/Y",$fi) : null ;
            $filtros["ff"] = $this->notEmpty($ff)  ? date_create_from_format("d/m/Y",$ff) : null ;
            $filtros["matricula"] = $matricula ? $matricula : null ;
            $filtros["estado"] = $estado ? $estado : -1 ;
            //Nuevos Filtros
            $filtros["remitoProductor"] = $remitoProductor ? $remitoProductor : null ;
            $filtros["variedad"] = $variedad && $variedad != -1 ? $variedad : null;
            $filtros["chacra"] = $chacra && $chacra != -1 ? $chacra : null;
            $filtros["empresa"] = $empresa && $empresa != -1 ? $empresa : null;
            $chacraTotal = 0;
            $netoTotal = 0;
            $productor = null;
            if($usuario->getTipo() == 2){
                $productor = $usuario->getReferencia();
                $filtros["productor"] = $productor ? $productor : null;
                //$chacras = $this->coreService()->chacrasPorProductor($productor)->getQuery()->getResult();
            }
            $admin = $productor == null ? 1 : 0;
            if($admin == 1){
                $productor = $this->getParam("productor");
                $productor = $productor == null || $productor == -1 ? null : $productor;
            }
            $filtros["planta"] = $admin == 1 ? $usuario->getPlanta() : null;
            $filtros["productor"] = $productor ? $productor : null;
            $entities = $this->coreService()->listarInfoProductorQuery($filtros)->getResult();
            $parametrosPromedios = $this->coreService()->promedioParametros($filtros,false);
            $totales = $this->coreService()->totalesNamed($filtros);
            $chacraTotal = $totales["arrozChacra"];
            $netoTotal =  $totales["arrozNeto"];
            //CODIGO PHP EXCEL
            $objReader = PHPExcel_IOFactory::createReader('Excel5');
            /**
             * @var \PHPExcel $objPHPExcel
             */
            $objPHPExcel = $objReader->load("bundles/core/excel/listado_productor_remitos.xls");

            /**
             * @var \PHPExcel_Worksheet $detallesBalanzaSheet
             */

            $detallesBalanzaSheet = $objPHPExcel->getSheetByName("Detalles de Balanza");

            $detallesBalanzaSheet
                ->setCellValue('G1', 'INFORMACION')
                ->setCellValue('G2', 'PRODUCTOR')
                ->setCellValue('C6', $usuario->getUsuario());
            if($nombreCompleto){
                $detallesBalanzaSheet->setCellValue('C7', $nombreCompleto);
            }else{
                $detallesBalanzaSheet->setCellValue('C7', 'Usuario Admin');
            }

            $detallesBalanzaSheet->setCellValue('C8', PHPExcel_Shared_Date::PHPToExcel( new \DateTime('now') ));
            $detallesBalanzaSheet->getStyle('C8')->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_DATE_DATETIME);
            $baseRow = 13;
            for($i = 0;$i < count($entities); $i++){



                $fila = $i + $baseRow;
                $r = $entities[$i];
                $cerrado = $r->getCerrado();

                $detallesBalanzaSheet->insertNewRowBefore($fila,1);
                $detallesBalanzaSheet
                    ->setCellValue('A' . $fila, $entities[$i]->getRemito());
                if($entities[$i]->getPlanta()){
                    $detallesBalanzaSheet
                        ->setCellValue('B' . $fila, $entities[$i]->getPlanta()->getNombre());
                }
                // columna C
                $parametros = $this->coreService()->CRUDBuscarPorId("Parametros",$r->getId());
                array_push($entitiesParametros, $parametros);
                if($cerrado == null || $cerrado == false){

                        if(($r->getFechaSalida()==null) && ($parametros->getCerrado()!=null)){
                            //abierto en balanza
                            $detallesBalanzaSheet->setCellValue('C' . $fila, 'Abierto en Balanza');
                            $detallesBalanzaSheet->getStyle('C' . $fila)->getFont()
                                ->setColor( new PHPExcel_Style_Color(PHPExcel_Style_Color::COLOR_RED  ) );
                        }
                        elseif(($r->getFechaSalida()!=null) && ($parametros->getCerrado()==null)){
                            //abierto en lab
                            $detallesBalanzaSheet->setCellValue('C' . $fila, 'Abierto en Laboratorio');
                            $detallesBalanzaSheet->getStyle('C' . $fila)->getFont()
                                ->setColor( new PHPExcel_Style_Color(PHPExcel_Style_Color::COLOR_RED  ) );
                        }
                        elseif(($r->getFechaSalida()==null) && ($parametros->getCerrado()==null)){
                            //remito abierto
                            $detallesBalanzaSheet->setCellValue('C' . $fila, 'Rémito Abierto');
                            $detallesBalanzaSheet->getStyle('C' . $fila)->getFont()
                                ->setColor( new PHPExcel_Style_Color(PHPExcel_Style_Color::COLOR_RED  ) );
                        }

                }else{
                    $detallesBalanzaSheet->setCellValue('C' . $fila, 'Rémito Cerrado');
                    $detallesBalanzaSheet->getStyle('C' . $fila)->getFont()
                        ->setColor( new PHPExcel_Style_Color(PHPExcel_Style_Color::COLOR_DARKGREEN  ) );
                }
                $detallesBalanzaSheet
                    ->setCellValue('D' . $fila, $entities[$i]->getProductor()->getNombre())
                    ->setCellValue('E' . $fila, $entities[$i]->getCamion()->getMatricula());

                // Columna F fecha entrada
                $detallesBalanzaSheet
                    ->setCellValue('F' . $fila, PHPExcel_Shared_Date::PHPToExcel( $entities[$i]->getFechaEntrada() ));
                $detallesBalanzaSheet
                    ->getStyle('F' . $fila)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_DATE_DATETIME);
                $resultados = $this->coreService()->CRUDBuscarPorId("Resultados",$r->getId());
                array_push($entitiesResultados, $resultados);
                $arrozChacra = $resultados->getArrozChacra();
                $arrozNeto = $resultados->getArrozNeto();
                if($resultados->getArrozChacra() == null){
                    $detallesBalanzaSheet->setCellValue('G' . $fila, '-');
                }else{
                    $detallesBalanzaSheet->setCellValue('G' . $fila, $arrozChacra);
                }
                if($resultados->getArrozNeto() == null){
                    $detallesBalanzaSheet->setCellValue('H' . $fila, '-');
                }else{
                    $detallesBalanzaSheet->setCellValue('H' . $fila, $arrozNeto);
                }
            }
            $detallesBalanzaSheet->removeRow($baseRow-1,1);
            $detallesBalanzaSheet
                ->setCellValue('A' . $fila, 'TOTALES:')
                ->setCellValue('G' . $fila, $chacraTotal)
                ->setCellValue('H' . $fila, $netoTotal);

            //-------
            $paramsSheet =  $objPHPExcel->getSheetByName("Detalles de Laboratorio");

            $baseRow = 13;
            for($i = 0; $i < count($entitiesParametros); $i++){
                $fila = $i + $baseRow;
                /**
                 * @var Parametros $p
                 */
                $p = $entitiesParametros[$i];

                $paramsSheet->insertNewRowBefore($fila,1);
                $paramsSheet
                    ->setCellValue('A' . $fila, $p->getId()->getRemito());
                if($p->getId()->getCerrado() == null || $p->getId()->getCerrado() == false){
                    $paramsSheet->setCellValue('B' . $fila, 'Rémito Abierto');
                    $paramsSheet->getStyle('B' . $fila)->getFont()
                        ->setColor( new PHPExcel_Style_Color(PHPExcel_Style_Color::COLOR_RED  ) );
                }else{
                    $paramsSheet->setCellValue('B' . $fila, 'Rémito Cerrado');
                    $paramsSheet->getStyle('B' . $fila)->getFont()
                        ->setColor( new PHPExcel_Style_Color(PHPExcel_Style_Color::COLOR_DARKGREEN  ) );
                }
                $paramsSheet
                    ->setCellValue('C' . $fila, ($p->getVariedad() ? $p->getVariedad()->getNombre() : ""));
                $paramsSheet
                    ->setCellValue('D' . $fila, $p->getHumedad());
                $paramsSheet
                    ->setCellValue('E' . $fila, $p->getVerdePrimario());
                $paramsSheet
                    ->setCellValue('F' . $fila, $p->getBasura());
                $paramsSheet
                    ->setCellValue('G' . $fila, $p->getBaseCargo());
                $paramsSheet
                    ->setCellValue('H' . $fila, $p->getVerdeOficial());
                $paramsSheet
                    ->setCellValue('I' . $fila, $p->getBaseBlanco());
                $paramsSheet
                    ->setCellValue('J' . $fila, $p->getGranoEntero());
                $paramsSheet
                    ->setCellValue('K' . $fila, $p->getQuebrado());
                $paramsSheet
                    ->setCellValue('L' . $fila, $p->getYeso());
                $paramsSheet
                    ->setCellValue('M' . $fila, $p->getRojo());
                $paramsSheet
                    ->setCellValue('N' . $fila, $p->getMancha());
            }

            $paramsSheet->removeRow($baseRow-1,1);
            $paramsSheet
                ->setCellValue('A' . $fila, 'Promedios:');

            $paramsSheet
                ->setCellValue('D' . $fila, $parametrosPromedios['humedad']);
            $paramsSheet
                ->setCellValue('E' . $fila, $parametrosPromedios['verdePrimario']);
            $paramsSheet
                ->setCellValue('F' . $fila, $parametrosPromedios['basura']);
            $paramsSheet
                ->setCellValue('G' . $fila, $parametrosPromedios['baseCargo']);
            $paramsSheet
                ->setCellValue('H' . $fila, $parametrosPromedios['verdeOficial']);
            $paramsSheet
                ->setCellValue('I' . $fila, $parametrosPromedios['baseBlanco']);
            $paramsSheet
                ->setCellValue('J' . $fila, $parametrosPromedios['granoEntero']);
            $paramsSheet
                ->setCellValue('K' . $fila, $parametrosPromedios['quebrado']);
            $paramsSheet
                ->setCellValue('L' . $fila, $parametrosPromedios['yeso']);
            $paramsSheet
                ->setCellValue('M' . $fila, $parametrosPromedios['rojo']);
            $paramsSheet
                ->setCellValue('N' . $fila, $parametrosPromedios['mancha']);


            $resultsSheet =  $objPHPExcel->getSheetByName("Resultados Finales");

            $baseRow = 13;
            for($i = 0; $i < count($entitiesParametros); $i++){
                $fila = $i + $baseRow;
                /**
                 * @var Resultados $re
                 */
                $re = $entitiesResultados[$i];

                $resultsSheet->insertNewRowBefore($fila,1);
                $resultsSheet
                    ->setCellValue('A' . $fila, $re->getId()->getRemito());
                $resultsSheet
                    ->setCellValue('B' . $fila, $re->getArrozChacra());
                $resultsSheet
                    ->setCellValue('C' . $fila, $re->getArrozSL());
                $resultsSheet
                    ->setCellValue('D' . $fila, $re->getPremioCastigo());
                $resultsSheet
                    ->setCellValue('E' . $fila, $re->getArrozSSL());
                $resultsSheet
                    ->setCellValue('F' . $fila, $re->getServicioSecado());
                $resultsSheet
                    ->setCellValue('G' . $fila, $re->getArrozNeto());
            }
            $resultsSheet->removeRow($baseRow-1,1);

            $resultsSheet
                ->setCellValue('B' . $fila, $totales["arrozChacra"]);
            $resultsSheet
                ->setCellValue('C' . $fila, $totales["arrozSL"]);
            $resultsSheet
                ->setCellValue('D' . $fila, $totales["arrozPremioCastigo"]);
            $resultsSheet
                ->setCellValue('E' . $fila, $totales["arrozSSL"]);
            $resultsSheet
                ->setCellValue('F' . $fila, $totales["arrozServicioSecado"]);
            $resultsSheet
                ->setCellValue('G' . $fila, $totales["arrozNeto"]);

            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $response = $this->get('phpexcel')->createStreamedResponse($objWriter);
            $response->headers->set('Content-Type', 'text/vnd.ms-excel; charset=utf-8');
            $response->headers->set('Content-Disposition', 'attachment;filename=listado_productor_remitos.xls');
            $response->headers->set('Pragma', 'public');
            $response->headers->set('Cache-Control', 'maxage=1');
            return $response;

        }
        return $this->redirect($this->generateUrl("productor_remitos_listar"));
    }



    public function listarAction()
    {
        $parametros = array();
        $estadoremito = 0;
        $pagerHtml = null;

        $remito = $this->getParam("remito");
        $fi = $this->getParam("fi");
        $ff = $this->getParam("ff");

        $matricula = $this->getParam("matricula");
        $estado = $this->getParam("estado");

        $remitoProductor = $this->getParam("remitoProductor");
        $productores = $this->coreService()->CRUDlistar("Productor");
        //Nuevos filtros
        $variedades = $this->coreService()->CRUDlistar("Variedad");
        $chacras = $this->coreService()->CRUDlistar("Chacra");
        $variedad = $this->getParam("variedad");
        $chacra = $this->getParam("chacra");
        $empresas = $this->coreService()->CRUDlistar("Empresa");
        $empresa = $this->getParam("empresa");

        $filtros = array();
        $filtros["fi"] = $this->notEmpty($fi)  ? date_create_from_format("d/m/Y",$fi) : null ;
        $filtros["ff"] = $this->notEmpty($ff)  ? date_create_from_format("d/m/Y",$ff) : null ;

        $filtros["remito"] = $remito ? $remito : null ;
        $filtros["matricula"] = $matricula ? $matricula : null ;
        $filtros["estado"] = $estado ? $estado : -1 ;
        //Nuevos Filtros
        $filtros["remitoProductor"] = $remitoProductor ? $remitoProductor : null ;
        $filtros["variedad"] = $variedad && $variedad != -1 ? $variedad : null;
        $filtros["chacra"] = $chacra && $chacra != -1 ? $chacra : null;
        $filtros["empresa"] = $empresa && $empresa != -1 ? $empresa : null;
        $chacraTotal = 0;
        $netoTotal = 0;

        $user = $this->getUser();
        $productor = null; // id de usuario logeado
        if($user->getTipo() == 2){
            $productor = $user->getReferencia();
            $filtros["productor"] = $productor ? $productor : null;
            //$chacras = $this->coreService()->chacrasPorProductor($productor)->getQuery()->getResult();
        }

        $admin = $productor == null ? 1 : 0;
        if($admin == 1){
            $productor = $this->getParam("productor");
            $productor = $productor == null || $productor == -1 ? null : $productor;
        }


        $filtros["planta"] = $admin == 1 ? $user->getPlanta() : null;
        $filtros["productor"] = $productor ? $productor : null;


        $page = $this->getParam("page");
        if(!$page)
            $page = 1;

        $queryBuilder = $this->coreService()->listarInfoProductorQuery($filtros);
        $totales = $this->coreService()->totales($filtros);
        $chacraTotal = number_format($totales[0], 2, '.', ',');
        $netoTotal =  number_format($totales[1], 2, '.', ',');
        $slTotal =  number_format($totales[2], 2, '.', ',');
        $pcTotal =  number_format($totales[3], 2, '.', ',');
        $sslTotal =  number_format($totales[4], 2, '.', ',');
        $ssTotal =  number_format($totales[5], 2, '.', ',');
        list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"productor_remitos_listar");

        $data = array();
        $entitiesResultados = array();
        $entitiesParametros = array();
        $parametrosPromedios = $this->coreService()->promedioParametros($filtros);
        for($i =0; $i<count($entities);$i++){
            $dataRemito = array();
            /**
             * @var Registro $r
             */
            $r = $entities[$i];
            $cerrado = $r->getCerrado();

            if ($cerrado == null || $cerrado == false)
                $estadoremito = -1;
            else
                $estadoremito = 1;

            $dataRemito["id"]=$r->getId(); //Id en Registro
            $dataRemito["registro"]=$r;
            $dataRemito["remito"]=$r->getRemito();
            $dataRemito["estado"]=$estadoremito;
            $dataRemito["matricula"]=$r->getCamion()->getMatricula();
            if ($r->getPlanta()){
                $dataRemito["planta"]=$r->getPlanta()->getNombre();
            }else{
                $dataRemito["planta"]= '';
            }

            $dataRemito["fechaEntrada"]=$r->getFechaEntrada();
            $dataRemito["Productor"]=$r->getProductor()->getNombre();
            if($r->getFechaSalida()== null)
                $dataRemito["fechaSalida"]="";
            else
                $dataRemito["fechaSalida"]=$r->getFechaSalida();

            $parametros = $this->coreService()->CRUDBuscarPorId("Parametros",$r->getId());
            if($parametros->getCerrado()){
                $dataRemito["Cerrado"]= 1;
            }else{
                $dataRemito["Cerrado"]= -1;
            }
            /**
             * @var Resultados $resultados
             */
            $resultados = $this->coreService()->CRUDBuscarPorId("Resultados",$r->getId());//resultados por registro

            if($resultados->getArrozChacra() == null){
                $dataRemito["Chacra"]="-";
            }else{
                $dataRemito["Chacra"]=number_format($resultados->getArrozChacra(), 2, '.', ',');
            }
            if($resultados->getArrozNeto() == null){

                $dataRemito["Neto"]="-";
            }else{
                $dataRemito["Neto"]=number_format($resultados->getArrozNeto(), 2, '.', ',');
            }
            array_push($entitiesResultados,$resultados);
            array_push($entitiesParametros,$parametros);
            array_push($data,$dataRemito);
        }

        return $this->render('CoreBundle:Default:productorListar.html.twig', array(
            "data"=>$data,
            "fi"=>$fi,
            "ff"=>$ff,
            "remito"=>$remito,
            "matricula"=>$matricula,
            "estado"=>$estado,
            "admin"=>$admin,
            "productores"=>$productores,
            "productor"=>$productor == null ? -1 : $productor,
            'pagerHtml' => $pagerHtml,
            'chacraTotal'=>$chacraTotal,
            'netoTotal'=>$netoTotal,
            'slTotal'=>$slTotal,
            'pcTotal'=>$pcTotal,
            'sslTotal'=>$sslTotal,
            'ssTotal'=>$ssTotal,
            'parametrosPromedios'=>$parametrosPromedios,
            "remitoProductor"=>$remitoProductor,
            "variedades"=>$variedades,
            "variedad"=>$variedad == null ? -1 : $variedad,
            "chacras"=>$chacras,
            "chacra"=>$chacra == null ? -1 : $chacra,
            "empresas"=>$empresas,
            "empresa"=>$empresa == null ? -1 : $empresa,
            "parametros" => $entitiesParametros,
            "resultados" => $entitiesResultados
        ));
    }

    public function showAction($id){
        $r = $this->coreService()->buscarRegistroPorId($id);
        $pesoEntrada = number_format($r->getPesoEntrada(), 2, '.', ',');
        $pesoSalida = number_format($r->getPesoSalida(), 2, '.', ',');
        $p = $this->coreService()->buscarParametrosPorRegistro($id);
        /**
         * @var Resultados  $re
         */
        $re = $this->coreService()->buscarResultadoPorId($id);
        $arrozChacra = number_format($re->getArrozChacra(), 2, '.', ',');
        $arrozSl = number_format($re->getArrozSL(), 2, '.', ',');
        $arrozSSL = number_format($re->getArrozSSL(), 2, '.', ',');
        $servicioSecado = number_format($re->getServicioSecado(), 2, '.', ',');
        $arrozNeto = number_format($re->getArrozNeto(), 2, '.', ',');
        $premioCastigo = number_format($re->getPremioCastigo(), 2, '.', ',');

        return $this->render('CoreBundle:Default:productorShow.html.twig', array(
            "r"=>$r,
            "pesoEntrada" => $pesoEntrada,
            "pesoSalida" => $pesoSalida,
            "p"=>$p,
            "re"=>$re,
            "arrozChacra" => $arrozChacra,
            "arrozSL" => $arrozSl,
            "arrozSSL" => $arrozSSL,
            "servicioSecado" => $servicioSecado,
            "arrozNeto" => $arrozNeto,
            "premioCastigo" => $premioCastigo
        ));
    }

    public function showMovilAction($id){
        $r = $this->coreService()->buscarRegistroPorId($id);
        $pesoEntrada = number_format($r->getPesoEntrada(), 2, '.', ',');
        $pesoSalida = number_format($r->getPesoSalida(), 2, '.', ',');
        $p = $this->coreService()->buscarParametrosPorRegistro($id);
        /**
         * @var Resultados  $re
         */
        $re = $this->coreService()->buscarResultadoPorId($id);
        $arrozChacra = number_format($re->getArrozChacra(), 2, '.', ',');
        $arrozSl = number_format($re->getArrozSL(), 2, '.', ',');
        $arrozSSL = number_format($re->getArrozSSL(), 2, '.', ',');
        $servicioSecado = number_format($re->getServicioSecado(), 2, '.', ',');
        $arrozNeto = number_format($re->getArrozNeto(), 2, '.', ',');
        $premioCastigo = number_format($re->getPremioCastigo(), 2, '.', ',');

        return $this->render('CoreBundle:Default:productorShowMovil.html.twig', array(
            "r"=>$r,
            "pesoEntrada" => $pesoEntrada,
            "pesoSalida" => $pesoSalida,
            "p"=>$p,
            "re"=>$re,
            "arrozChacra" => $arrozChacra,
            "arrozSL" => $arrozSl,
            "arrozSSL" => $arrozSSL,
            "servicioSecado" => $servicioSecado,
            "arrozNeto" => $arrozNeto,
            "premioCastigo" => $premioCastigo
        ));
    }


    public function listarMovilAction()
    {
        $parametros = array();
        $estadoremito = 0;
        $pagerHtml = null;

        $remito = $this->getParam("remito");
        $fi = $this->getParam("fi");
        $ff = $this->getParam("ff");

        $matricula = $this->getParam("matricula");
        $estado = $this->getParam("estado");
        $remitoProductor = $this->getParam("remitoProductor");
        $productores = $this->coreService()->CRUDlistar("Productor");
        //Nuevos filtros
        $variedades = $this->coreService()->CRUDlistar("Variedad");
        $chacras = $this->coreService()->CRUDlistar("Chacra");
        $variedad = $this->getParam("variedad");
        $chacra = $this->getParam("chacra");
        $empresas = $this->coreService()->CRUDlistar("Empresa");
        $empresa = $this->getParam("empresa");

        $filtros = array();
        $filtros["fi"] = $this->notEmpty($fi)  ? date_create_from_format("d/m/Y",$fi) : null ;
        $filtros["ff"] = $this->notEmpty($ff)  ? date_create_from_format("d/m/Y",$ff) : null ;

        $filtros["remito"] = $remito ? $remito : null ;
        $filtros["matricula"] = $matricula ? $matricula : null ;
        $filtros["estado"] = $estado ? $estado : -1 ;
        //Nuevos Filtros
        $filtros["remitoProductor"] = $remitoProductor ? $remitoProductor : null ;
        $filtros["variedad"] = $variedad && $variedad != -1 ? $variedad : null;
        $filtros["chacra"] = $chacra && $chacra != -1 ? $chacra : null;
        $filtros["empresa"] = $empresa && $empresa != -1 ? $empresa : null;
        $chacraTotal = 0;
        $netoTotal = 0;

        $user = $this->getUser();
        $productor = null; // id de usuario logeado
        if($user->getTipo() == 2){
            $productor = $user->getReferencia();
            $filtros["productor"] = $productor ? $productor : null;
            //$chacras = $this->coreService()->chacrasPorProductor($productor)->getQuery()->getResult();
        }

        $admin = $productor == null ? 1 : 0;
        if($admin == 1){
            $productor = $this->getParam("productor");
            $productor = $productor == null || $productor == -1 ? null : $productor;
        }


        $filtros["planta"] = $admin == 1 ? $user->getPlanta() : null;
        $filtros["productor"] = $productor ? $productor : null;


        $page = $this->getParam("page");
        if(!$page)
            $page = 1;

        $queryBuilder = $this->coreService()->listarInfoProductorQuery($filtros);
        $totales = $this->coreService()->totales($filtros);
        $chacraTotal = number_format($totales[0], 2, '.', ',');
        $netoTotal =  number_format($totales[1], 2, '.', ',');
        $slTotal =  number_format($totales[2], 2, '.', ',');
        $pcTotal =  number_format($totales[3], 2, '.', ',');
        $sslTotal =  number_format($totales[4], 2, '.', ',');
        $ssTotal =  number_format($totales[5], 2, '.', ',');
        list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"productor_remitos_listar");

        $data = array();
        $entitiesResultados = array();
        $entitiesParametros = array();
        $parametrosPromedios = $this->coreService()->promedioParametros($filtros);
        for($i =0; $i<count($entities);$i++){
            $dataRemito = array();
            /**
             * @var Registro $r
             */
            $r = $entities[$i];
            $cerrado = $r->getCerrado();

            if ($cerrado == null || $cerrado == false)
                $estadoremito = -1;
            else
                $estadoremito = 1;
            if($r->getPlanta()){
                $nombreplanta = $r->getPlanta()->getNombre();
            }else{
                $nombreplanta = '';
            }
            $dataRemito["id"]=$r->getId(); //Id en Registro
            $dataRemito["registro"]=$r;
            $dataRemito["remito"]=$r->getRemito();
            $dataRemito["estado"]=$estadoremito;
            $dataRemito["matricula"]=$r->getCamion()->getMatricula();
            $dataRemito["planta"]= $nombreplanta;
            $dataRemito["fechaEntrada"]=$r->getFechaEntrada();
            $dataRemito["Productor"]=$r->getProductor()->getNombre();
            if($r->getFechaSalida()== null)
                $dataRemito["fechaSalida"]="";
            else
                $dataRemito["fechaSalida"]=$r->getFechaSalida();

            $parametros = $this->coreService()->CRUDBuscarPorId("Parametros",$r->getId());
            array_push($entitiesParametros,$parametros);
            if($parametros->getCerrado()){
                $dataRemito["Cerrado"]= 1;
            }else{
                $dataRemito["Cerrado"]= -1;
            }
            /**
             * @var Resultados $resultados
             */
            $resultados = $this->coreService()->CRUDBuscarPorId("Resultados",$r->getId());//resultados por registro
            array_push($entitiesResultados,$resultados);
            if($resultados->getArrozChacra() == null){
                $dataRemito["Chacra"]="-";
            }else{
                $dataRemito["Chacra"]=number_format($resultados->getArrozChacra(), 2, '.', ',');
            }
            if($resultados->getArrozNeto() == null){

                $dataRemito["Neto"]="-";
            }else{
                $dataRemito["Neto"]=number_format($resultados->getArrozNeto(), 2, '.', ',');
            }
            array_push($data,$dataRemito);
        }

        //$parametros = $this->coreService()->listarInfoProductor($filtros);

        return $this->render('CoreBundle:Default:productorListarMovil.html.twig', array(

            "data"=>$data,
            "fi"=>$fi,
            "ff"=>$ff,
            "remito"=>$remito,
            "matricula"=>$matricula,
            "estado"=>$estado,
            "admin"=>$admin,
            "productores"=>$productores,
            "productor"=>$productor == null ? -1 : $productor,
            'pagerHtml' => $pagerHtml,
            'chacraTotal'=>$chacraTotal,
            'netoTotal'=>$netoTotal,
            "remitoProductor"=>$remitoProductor,
            "variedades"=>$variedades,
            "variedad"=>$variedad == null ? -1 : $variedad,
            "chacras"=>$chacras,
            "chacra"=>$chacra == null ? -1 : $chacra,
            "empresas"=>$empresas,
            "empresa"=>$empresa == null ? -1 : $empresa,
            "parametros" => $entitiesParametros,
            "resultados" => $entitiesResultados,
            'slTotal'=>$slTotal,
            'pcTotal'=>$pcTotal,
            'sslTotal'=>$sslTotal,
            'ssTotal'=>$ssTotal,
            'parametrosPromedios'=>$parametrosPromedios,
        ));
    }

    /**
     * @Pdf()
     */
    public function printRemitoAction($id){
        $format = $this->get('request')->get('_format');
        $registro = $this->coreService()->buscarRegistroPorId($id);
        $resultado = $this->coreService()->buscarResultadoPorId($id);
        if($registro){
            $usuario = null;
            if($registro->getUsuario()){
                $usuario = $this->coreService()->CRUDBuscarPorId("Usuario",$registro->getUsuario());
                $ref_ = $this->coreService()->CRUDBuscarPorId( ($usuario->getTipo() == 1 ? "Empleado" : "Productor"),$usuario->getReferencia()) ;
                $usuario->setDetalles($ref_);
            }
            $response = $this->render(sprintf('CoreBundle::print_remito.%s.twig', $format), array(
                'registro'=>$registro,
                "usuario"=>$usuario,
                "resultado"=>$resultado
            ));
            $response->headers->set("Content-Disposition","attachment; filename=\"reporte.pdf\"");
            return $response;
        }
        return $this->redirect($this->generateUrl("core_home"));
    }

    /**
     * @Pdf()
     */
    public function printParametrosAction($id){
        $format = $this->get('request')->get('_format');
        $parametros = $this->coreService()->buscarParametrosPorRegistro($id);
        if($parametros){
            $usuario = null;
            if($parametros->getId()->getUsuario()){
                $usuario = $this->coreService()->CRUDBuscarPorId("Usuario",$parametros->getId()->getUsuario());
                $ref_ = $this->coreService()->CRUDBuscarPorId( ($usuario->getTipo() == 1 ? "Empleado" : "Productor"),$usuario->getReferencia()) ;
                $usuario->setDetalles($ref_);
            }
            $response = $this->render(sprintf('CoreBundle::print_parametros.%s.twig', $format), array('parametros'=>$parametros,
                "usuario"=>$usuario));
            $response->headers->set("Content-Disposition","attachment; filename=\"reporte.pdf\"");
            return $response;
        }
        return $this->redirect($this->generateUrl("core_home"));
    }

    public function notificacionesAction($id){
        /**
         * @var Productor $productor
         */
        $productor = $this->coreService()->CRUDBuscarPorId("Productor",$id);
        if($productor){
            if($this->isPost()){
                $remitoCerrado = $this->getParam("remito_cerrado");
                $balanzaCerrada = $this->getParam("balanza_cerrada");
                $productor->setNotificacionBalanzaCerrada( $balanzaCerrada == 1 );
                $productor->setNotificacionRemitoCerrado( $remitoCerrado == 1);
                $this->coreService()->save($productor,true);
                return $this->redirect($this->generateUrl("core_home"));
            }
            return $this->render('CoreBundle:Default:productorNotificaciones.html.twig', array(
                'productor'=>$productor
            ));
        }
        return $this->redirect($this->generateUrl("core_home"));
    }


    public function notificacionesMovilAction($id){
        /**
         * @var Productor $productor
         */
        $productor = $this->coreService()->CRUDBuscarPorId("Productor",$id);
        if($productor){
            if($this->isPost()){
                $remitoCerrado = $this->getParam("remito_cerrado");
                $balanzaCerrada = $this->getParam("balanza_cerrada");
                $productor->setNotificacionBalanzaCerrada( $balanzaCerrada == 1 );
                $productor->setNotificacionRemitoCerrado( $remitoCerrado == 1);
                $this->coreService()->save($productor,true);
                return $this->redirect($this->generateUrl("core_home"));
            }
            return $this->render('CoreBundle:Default:productorNotificacionesMovil.html.twig', array(
                'productor'=>$productor
            ));
        }
        return $this->redirect($this->generateUrl("productor_remitos_show_movil"));
    }


    public function productorLaboratorioAction(){

        $entities = array();
        $fi = null;
        $ff = null;
        $pagerHtml = null;

        $planta = null;
        $remito = $this->getParam("remito");
        $fi = $this->getParam("fi");
        $ff = $this->getParam("ff");
        $estado = $this->getParam("estado");
        $filtros = array();
        $filtros["fi"] = $this->notEmpty($fi)  ? date_create_from_format("d/m/Y",$fi) : null ;
        $filtros["ff"] = $this->notEmpty($ff)  ? date_create_from_format("d/m/Y",$ff) : null ;
        $filtros["remito"] = $remito ? $remito : null ;
        $filtros["estado"] = $estado ? $estado : -1 ;
        $user = $this->getUser();
        $productor = null; // id de usuario logeado
        if($user->getTipo() == 2){
            $productor = $user->getReferencia();
            $filtros["productor"] = $productor ? $productor : null;
        }else{
            $filtros["productor"] = null;
        }

        $page = $this->getParam("page");
        if(!$page)
            $page = 1;

        $queryBuilder = $this->coreService()->listarParametrosFiltroQuery($filtros, $planta);
        list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"laboratorio_listar");

        return $this->render('CoreBundle:Default:productorLaboratorio.html.twig', array(
            "parametros"    => $entities,
            "remito"        => $remito,
            "fi"            => $fi,
            "ff"            => $ff,
            "estado"        => $estado,
            'productor'     => $productor,
            'pagerHtml'     => $pagerHtml,
        ));
    }

    public function productorLaboratorioMovilAction(){

        $entities = array();
        $fi = null;
        $ff = null;
        $pagerHtml = null;

        $planta = null;
        $remito = $this->getParam("remito");
        $fi = $this->getParam("fi");
        $ff = $this->getParam("ff");
        $estado = $this->getParam("estado");
        $filtros = array();
        $filtros["fi"] = $this->notEmpty($fi)  ? date_create_from_format("d/m/Y",$fi) : null ;
        $filtros["ff"] = $this->notEmpty($ff)  ? date_create_from_format("d/m/Y",$ff) : null ;
        $filtros["remito"] = $remito ? $remito : null ;
        $filtros["estado"] = $estado ? $estado : -1 ;
        $user = $this->getUser();
        $productor = null; // id de usuario logeado
        if($user->getTipo() == 2){
            $productor = $user->getReferencia();
            $filtros["productor"] = $productor ? $productor : null;
        }else{
            $filtros["productor"] = null;
        }

        $page = $this->getParam("page");
        if(!$page)
            $page = 1;

        $queryBuilder = $this->coreService()->listarParametrosFiltroQuery($filtros, $planta);
        list($entities,$pagerHtml) = $this->paginatorRuter($queryBuilder,$page,"laboratorio_listar");

        return $this->render('CoreBundle:Default:productorLaboratorioMovil.html.twig', array(
            "parametros"    => $entities,
            "remito"        => $remito,
            "fi"            => $fi,
            "ff"            => $ff,
            "estado"        => $estado,
            'productor'     => $productor,
            'pagerHtml'     => $pagerHtml,
        ));
    }


}
