<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 22/01/14
 * Time: 16:28
 */

namespace Sigza\CoreBundle\Entity;

use Doctrine\ORM\QueryBuilder;

class ParametrosRepository extends CommonCRUDRepository{

    /**
     * @param $remito
     * @return array
     */
    public function buscarPorRemito($remito){
        $query = $this->_em->createQueryBuilder();
        $query->select("p")->from($this->_entityName,"p");
        $query->innerJoin("p.registro","r","WITH"," LOWER(r.remito) like :remito");
        $query->setParameter("remito",strtolower("%$remito%"));
        $query->setMaxResults(30);
        $result = $query->getQuery()->getResult();
        if(!count($result))
            return array();
        return $result;
    }

    /**
     * @param array $filtros
     * @return array
     */
    public function buscarPorFiltro(array $filtros){
        $planta = "";
        return $this->buscarPorFiltroQuery($filtros, $planta)->getResult();
    }

    public function buscarPorFiltroQuery(array $filtros, $planta){
        $remito = $this->getKeyValue("remito",$filtros);
        $fi = $this->getKeyValue("fi",$filtros);
        $ff = $this->getKeyValue("ff",$filtros);
        $estado = $this->getKeyValue("estado",$filtros);
        $productor = $this->getKeyValue("productor",$filtros);

        $matricula = $this->getKeyValue("matricula",$filtros);
        $planta = $this->getKeyValue("planta",$filtros);
        // Nuevos filtros
        $remitoProductor = $this->getKeyValue("remitoProductor",$filtros);
        $variedad = $this->getKeyValue("variedad",$filtros);
        $chacra = $this->getKeyValue("chacra",$filtros);
        $empresa = $this->getKeyValue("empresa",$filtros);

        $query = $this->_em->createQueryBuilder();
        $query->select("p")->from($this->_entityName,"p");
        $query->innerJoin("p.id","r");

        if($matricula != null){
            $query->innerJoin("r.camion","c");
        }

        $query->where(" p.id is not null ");


        if($remito != null){
            $query->andWhere(" LOWER(r.remito) =:remito ");
            $query->setParameter("remito",strtolower($remito));
        }

        if($fi != null){
            $query->andWhere(" r.fechaEntrada >= :fi  ");
            $query->setParameter("fi",$fi);
        }

        if($ff != null){
            $query->andWhere(" r.fechaEntrada <= :ff  ");
            $query->setParameter("ff",$ff);
        }

        if($planta){
            $query->andWhere("r.planta =:planta");
            $query->setParameter("planta",$planta);
        }

        if($productor){
            $query->andWhere("r.productor =:productor");
            $query->setParameter("productor",$productor);
        }

        if($estado != -1){
            if($estado == 1)
                $query->andWhere(" r.cerrado = 0 OR r.cerrado is null ");
            else
                $query->andWhere(" r.cerrado = 1 ");
            //$query->setParameter("estado",($estado != 1));
        }

        if($matricula != null){
            $query->andWhere(" c.matricula =:matricula  ");
            $query->setParameter("matricula",$matricula);
        }

        if($remitoProductor != null){
            $query->andWhere(" LOWER(r.remitoProductor) =:remitoProductor ");
            $query->setParameter("remitoProductor",strtolower($remitoProductor));
        }

        if($variedad){
            $query->andWhere(" r.variedad =:variedad  ");
            $query->setParameter("variedad",$variedad);
        }

        if($chacra){
            $query->andWhere(" r.chacra =:chacra  ");
            $query->setParameter("chacra",$chacra);
        }
        if($empresa){
            $query->andWhere(" c.empresa =:empresa  ");
            $query->setParameter("empresa",$empresa);
        }

        $query->orderBy("r.fechaEntrada","desc");


        return $query->getQuery();
    }

    public function totales(array $filtros){
        $remito = $filtros["remito"];
        $fi = $filtros["fi"];
        $ff = $filtros["ff"];
        $estado = $filtros["estado"];
        $productor = $filtros["productor"];
        $matricula = $filtros["matricula"];
        $planta = $filtros["planta"];
        // Nuevos filtros
        $remitoProductor = $filtros["remitoProductor"];
        $variedad = $filtros["variedad"];
        $chacra = $filtros["chacra"];
        $empresa = $filtros["empresa"];

        $query = $this->_em->createQueryBuilder();
        $query->select( "SUM(re.humedad) as humedad, SUM(re.verdePrimario) as verdePrimario, SUM(re.baseBlanco) as baseBlanco, SUM(re.verdeOficial) as verdeOficial, SUM(re.basura) as basura, SUM(re.baseCargo) as baseCargo, SUM(re.granoEntero) as granoEntero, SUM(re.quebrado) as quebrado, SUM(re.yeso) as yeso, SUM(re.rojo) as rojo, SUM(re.mancha) as mancha" )->from($this->_entityName,"re");
        $query->innerJoin("re.id","r");

        if($matricula != null){
            $query->innerJoin("r.camion","c");
        }

        if($empresa != null){
            $query->innerJoin("r.camion","c");
        }


        $query->where(" r.id is not null AND r.pesoSalida is not null ");

        if($remito != null){
            $query->andWhere(" LOWER(r.remito) =:remito ");
            $query->setParameter("remito",strtolower($remito));
        }

        if($fi != null){
            $query->andWhere(" r.fechaEntrada >= :fi  ");
            $query->setParameter("fi",$fi);
        }

        if($ff != null){
            $query->andWhere(" r.fechaEntrada <= :ff  ");
            $query->setParameter("ff",$ff);
        }

        if($estado != -1){
            if($estado == 1)
                $query->andWhere(" r.cerrado =:estado OR r.cerrado is null ");
            else
                $query->andWhere(" r.cerrado =:estado ");
            $query->setParameter("estado",($estado != 1));
        }

        if($productor != null){
            $query->andWhere(" r.productor =:productor  ");
            $query->setParameter("productor",$productor);
        }

        if($matricula != null){
            $query->andWhere(" c.matricula =:matricula  ");
            $query->setParameter("matricula",$matricula);
        }

        if($planta){
            $query->andWhere(" r.planta =:planta  ");
            $query->setParameter("planta",$planta);
        }
        //Nuevos Filtros
        if($remitoProductor != null){
            $query->andWhere(" LOWER(r.remitoProductor) =:remitoProductor ");
            $query->setParameter("remitoProductor",strtolower($remitoProductor));
        }

        if($variedad){
            $query->andWhere(" r.variedad =:variedad  ");
            $query->setParameter("variedad",$variedad);
        }

        if($chacra){
            $query->andWhere(" r.chacra =:chacra  ");
            $query->setParameter("chacra",$chacra);
        }
        if($empresa){
            $query->andWhere(" c.empresa =:empresa  ");
            $query->setParameter("empresa",$empresa);
        }
        $ch = $query->getQuery()->getResult();
        $ch = $ch[0];
        return $ch;
    }

    public function aveName(array $filtros, $propName){
        $remito = $filtros["remito"];
        $fi = $filtros["fi"];
        $ff = $filtros["ff"];
        $estado = $filtros["estado"];
        $productor = $filtros["productor"];
        $matricula = $filtros["matricula"];
        $planta = $filtros["planta"];
        // Nuevos filtros
        $remitoProductor = $filtros["remitoProductor"];
        $variedad = $filtros["variedad"];
        $chacra = $filtros["chacra"];
        $empresa = $filtros["empresa"];

        $query = $this->_em->createQueryBuilder();
        $query->select( "COUNT(re.".$propName.") as conteo, SUM(re.".$propName.") as suma" )->from($this->_entityName,"re");
        $query->innerJoin("re.id","r");

        if($matricula != null){
            $query->innerJoin("r.camion","c");
        }

        if($empresa != null){
            $query->innerJoin("r.camion","c");
        }


        $query->where(" r.id is not null AND r.pesoSalida is not null ");

        $query->andWhere( $query->expr()->isNotNull("re.".$propName) );

        if($remito != null){
            $query->andWhere(" LOWER(r.remito) =:remito ");
            $query->setParameter("remito",strtolower($remito));
        }

        if($fi != null){
            $query->andWhere(" r.fechaEntrada >= :fi  ");
            $query->setParameter("fi",$fi);
        }

        if($ff != null){
            $query->andWhere(" r.fechaEntrada <= :ff  ");
            $query->setParameter("ff",$ff);
        }

        if($estado != -1){
            if($estado == 1)
                $query->andWhere(" r.cerrado =:estado OR r.cerrado is null ");
            else
                $query->andWhere(" r.cerrado =:estado ");
            $query->setParameter("estado",($estado != 1));
        }

        if($productor != null){
            $query->andWhere(" r.productor =:productor  ");
            $query->setParameter("productor",$productor);
        }

        if($matricula != null){
            $query->andWhere(" c.matricula =:matricula  ");
            $query->setParameter("matricula",$matricula);
        }

        if($planta){
            $query->andWhere(" r.planta =:planta  ");
            $query->setParameter("planta",$planta);
        }
        //Nuevos Filtros
        if($remitoProductor != null){
            $query->andWhere(" LOWER(r.remitoProductor) =:remitoProductor ");
            $query->setParameter("remitoProductor",strtolower($remitoProductor));
        }

        if($variedad){
            $query->andWhere(" r.variedad =:variedad  ");
            $query->setParameter("variedad",$variedad);
        }

        if($chacra){
            $query->andWhere(" r.chacra =:chacra  ");
            $query->setParameter("chacra",$chacra);
        }
        if($empresa){
            $query->andWhere(" c.empresa =:empresa  ");
            $query->setParameter("empresa",$empresa);
        }



        $ch = $query->getQuery()->getResult();
        $ch = $ch[0];
        $count = intval($ch['conteo']) ;
        $sum = floatval($ch['suma']);
        return $count > 0 ? floatval($sum / $count) : $sum;
    }





} 