<?php
/**
 * Created by PhpStorm.
 * User: TECRA-M5
 * Date: 23/01/14
 * Time: 17:27
 */

namespace Sigza\CoreBundle\Service;
use Doctrine\ORM\EntityRepository;
use Sigza\CoreBundle\Entity as entity;

class CoreService extends BaseService{

    /**
     * @var entity\RegistroRepository
     */
    private $registroRepository;

    /**
     * @var entity\CamionRepository
     */
    private $camionRepository;

    /**
     * @var entity\ChacraRepository
     */
    private $chacraRepository;

    /**
     * @var entity\OrigenDestinoRepository
     */
    private $origenDestinoRepository;

    /**
     * @var entity\ParametrosRepository
     */
    private $parametrosRepository;

    /**
     * @var entity\PlantaRepository
     */
    private $plantaRepository;

    /**
     * @var entity\ProductoRepository
     */
    private $productoRepository;

    /**
     * @var entity\ProductorRepository
     */
    private $productorRepository;

    /**
     * @var entity\RolRepository
     */
    private $rolRepository;

    /**
     * @var entity\TipoDocumentosRepository
     */
    private $tipoDocumentosRepository;

    /**
     * @var entity\ToleranciaRepository
     */
    private $toleranciaRepository;

    /**
     * @var entity\UsuarioRepository
     */
    private $usuarioRepository;

    /**
     * @var entity\VariedadRepository
     */
    private $variedadRepository;

    /**
     * @var entity\EmpresaRepository
     */
    private $empresaRepository;

    /**
     * @var entity\ResultadosRepository
     */
    private $resultadosRepository;

    /**
     * @var entity\BaseRepository
     */
    private $baseRepository;

    /**
     * @var entity\BaseGranoEnteroVariedadRepository
     */
    private $baseGranoEnteroVariedadRepository;

    /**
     * @var entity\EmpleadoRepository
     */
    private $empleadoRepository;

    private $CRUDRepositories = null;




    //------- Incicializaci'on de los repos
    public function initRepos()
    {
        $this->registroRepository = $this->getRepository("Registro");
        $this->camionRepository = $this->getRepository("Camion");
        $this->chacraRepository = $this->getRepository("Chacra");
        $this->origenDestinoRepository = $this->getRepository("OrigenDestino");
        $this->parametrosRepository = $this->getRepository("Parametros");
        $this->plantaRepository = $this->getRepository("Planta");
        $this->productoRepository = $this->getRepository("Producto");
        $this->productorRepository = $this->getRepository("Productor");
        $this->rolRepository = $this->getRepository("Rol");
        $this->tipoDocumentosRepository = $this->getRepository("TipoDocumentos");
        $this->toleranciaRepository = $this->getRepository("Tolerancia");
        $this->baseRepository = $this->getRepository("Base");
        $this->usuarioRepository = $this->getRepository("Usuario");
        $this->variedadRepository = $this->getRepository("Variedad");
        $this->empresaRepository = $this->getRepository("Empresa");
        $this->resultadosRepository = $this->getRepository("Resultados");
        $this->empleadoRepository = $this->getRepository("Empleado");
        $this->baseGranoEnteroVariedadRepository = $this->getRepository("BaseGranoEnteroVariedad");
        $this->CRUDRepositories = array(
            "Camion"=>$this->camionRepository,
            "Empresa"=>$this->empresaRepository,
            "Planta"=>$this->plantaRepository,
            "Productor"=>$this->productorRepository,
            "Producto"=>$this->productoRepository,
            "Chacra"=>$this->chacraRepository,
            "OrigenDestino"=>$this->origenDestinoRepository,
            "Variedad"=>$this->variedadRepository,
            "Usuario"=>$this->usuarioRepository,
            "Rol"=>$this->rolRepository,
            "Registro"=>$this->registroRepository,
            "Parametros"=>$this->parametrosRepository,
            "Resultados"=>$this->resultadosRepository,
            "Empleado"=>$this->empleadoRepository,
            "Base"=>$this->baseRepository,
            "BaseGranoEnteroVariedad"=>$this->baseGranoEnteroVariedadRepository,
            "Tolerancia"=>$this->toleranciaRepository);
    }

    //------------------- Cruds

    /**
     * @param $entity
     * @return EntityRepository|null
     */
    private function CRUDRepo($entity){
        if(!array_key_exists($entity,$this->CRUDRepositories))
            return null;
        return $this->CRUDRepositories[$entity];
    }

    /**
     * @param $entityName
     * @return array
     */
    public function CRUDlistar($entityName){
        $rep = $this->CRUDRepo($entityName);
        if($rep != null){
            return $rep->findAll();
        }
        return array();
    }

    /**
     * Devuelve la Query para ser utilizada directamente por PagerFanta
     * @param $entityName
     * @return \Doctrine\ORM\QueryBuilder|null
     */
    public function CRUDlistarQuery($entityName){
        $rep = $this->CRUDRepo($entityName);
        if($rep != null){
            return $rep->listaQuery();
        }
        return null;
    }



    public function CRUDBuscarPorId($entityName,$idPropValue){
        $rep = $this->CRUDRepo($entityName);
        if($rep != null){
            return $rep->findOneBy(array('id'=>$idPropValue));
        }
        return null;
    }
     //-----------------------
    /**
     * @param $remito
     * @return entity\Registro|null
     */
    public function buscarRegistroPorRemito($remito)
    {
        return $this->registroRepository->findOneByRemito($remito);
    }

    /**
     * @param $remito
     * @return array|null
     */
    public function buscarRegistrosPorRemito($remito)
    {
        return $this->registroRepository->buscarPorRemito($remito);
    }

    public function buscarRegistrosPorRemitoQuery($remito, $planta)
    {
        return $this->registroRepository->buscarPorRemitoQuery($remito, $planta);
    }

    public function totalChacra($remito, $planta)
    {
        return $this->registroRepository->totalChacra($remito, $planta);
    }

    /**
     * @param $remito
     * @return array|null
     */
    public function buscarRegistrosPorRemitosAbiertos($remito)
    {
        return $this->registroRepository->buscarPorRemitosAbiertos($remito);
    }

    public function buscarRegistrosPorRemitosAbiertosQuery($remito, $planta)
    {
        return $this->registroRepository->buscarPorRemitosAbiertosQuery($remito, $planta);
    }

    public function listarRegistrosPorRemitosAbiertosOrdenadosPorFecha($planta)
    {
        return $this->registroRepository->listarRemitosAbiertosPorFechaEntrada($planta);
    }

    public function listarRegistrosPorRemitosOrdenadosPorFecha($planta)
    {
        return $this->registroRepository->listarRemitosPorFechaEntrada($planta);
    }

    /**
     * @param $remito
     * @return array
     */
    public function buscarParametrosPorRemito($remito)
    {
        return $this->parametrosRepository->buscarPorRemito($remito);
    }

    /**
     * @param $r
     * @return entity\Parametros|null
     */
    public function buscarParametrosPorRegistro($r)
    {
        return $this->parametrosRepository->findOneById($r);
    }

    public function registroCerrado($registro){
        if(!$registro instanceof entity\Registro)
            $registro = $this->CRUDBuscarPorId("Registro",$registro);
        return $registro->getFechaSalida() != null;
    }

    public function remitoCerrado(entity\Registro $registro){
        return ($this->labCerrado($registro->getRemito()) &&
            ($this->registroCerrado($registro)));
    }

    public function labCerrado($remito){
        $r = $this->registroRepository->findOneByRemito($remito);
        /**
         * @var entity\Parametros $p
         */
        $p = $this->parametrosRepository->findOneById($r->getId());
        if(!$p) // no existen params
           return false;
        else{
            if($p->getCerrado() === true)
                return true;
            if($p->getVerdePrimario() == null)
                return false;
            if($p->getBaseBlanco() == null)
                return false;
            if($p->getBaseCargo() == null)
                return false;
            if($p->getBasura() == null)
                return false;
            if($p->getGranoEntero() == null)
                return false;
            if($p->getMancha() == null)
                return false;
            if($p->getRojo() == null)
                return false;
            if($p->getYeso() == null)
                return false;
            if($p->getVerdeOficial() == null)
                return false;
            if($p->getQuebrado() == null)
                return false;
        }

        return true;
    }


    /**
     * @param $id
     * @return entity\Registro|null
     */
    public function buscarRegistroPorId($id)
    {
        return $this->registroRepository->findOneById($id);
    }

    /**
     * @param $id
     * @return entity\Resultados|null
     */
    public function buscarResultadoPorId($id)
    {
        return $this->resultadosRepository->findOneById($id);
    }

    /**
     * @param $id
     * @return entity\Camion|null
     */
    public function buscarCamionPorId($id)
    {
        return $this->camionRepository->findOneById($id);
    }

    /**
     * @param $id
     * @return entity\Parametros|null
     */
    public function buscarParametrosPorId($id)
    {
        return $this->parametrosRepository->findOneById($id);
    }



    /**
     * @param $matricula
     * @return entity\Camion|null
     */
    public function buscarCamionPorMatricula($matricula)
    {
        return $this->camionRepository->findOneBy(array("matricula"=>$matricula));
    }



    /**
     * @param $matricula
     * @return array|null
     */
    public function buscarCamionesPorMatricula($matricula)
    {
        return $this->camionRepository->buscarPorMatricula($matricula);
    }

    /**
     * @param $matricula
     * @return array|null
     */
    public function buscarCamionesPorMatriculaQuery($matricula)
    {
        return $this->camionRepository->buscarPorMatriculaQuery($matricula);
    }



    /**
     * @param $camion
     * @return null|entity\Registro
     */

    public function remitoAbierto($camion){
        return $this->registroRepository->buscarRemitoAbierto($camion);
    }

    /**
     * @return array|null
     */
    public function listarParametros()
    {
        return $this->parametrosRepository->findAll();
    }


    /**
     * @param array $filtros
     * @return array
     */
    public function listarParametrosFiltro(array $filtros)
    {
        return $this->parametrosRepository->buscarPorFiltro($filtros);
    }

    public function listarParametrosFiltroQuery(array $filtros, $planta)
    {
        return $this->parametrosRepository->buscarPorFiltroQuery($filtros, $planta);
    }

    public function listarResultadosFiltroQuery(array $filtros, $planta)
    {
        return $this->resultadosRepository->buscarPorFiltroQuery($filtros, $planta);
    }

    /**
     * @param array $filtros
     * @return array
     */
    public function listarInfoProductor(array $filtros)
    {
        return $this->registroRepository->buscarPorFiltro($filtros);
    }

    public function listarInfoProductorQuery(array $filtros)
    {
        return $this->registroRepository->buscarPorFiltroQuery($filtros);
    }

    public function totales(array $filtros){
        $resultadosTotales = $this->resultadosRepository->totales($filtros);
        $totales = array($this->registroRepository->chacrasTotales($filtros), $resultadosTotales['an'], $resultadosTotales['sl'], $resultadosTotales['pc'], $resultadosTotales['ssl'],$resultadosTotales['ss']);
        return $totales;
    }

    public function totalesNamed(array $filtros){
        $totales = $this->totales($filtros);
        $totalesNamed = array();
        $totalesNamed["arrozChacra"] = $totales[0];
        $totalesNamed["arrozNeto"] = $totales[1];
        $totalesNamed["arrozSL"] = $totales[2];
        $totalesNamed["arrozPremioCastigo"] = $totales[3];
        $totalesNamed["arrozSSL"] = $totales[4];
        $totalesNamed["arrozServicioSecado"] = $totales[5];
        return $totalesNamed;
    }

    public function promedioParametros(array $filtros, $formated = true){

        $keys = array("humedad","verdePrimario","basura","baseCargo","baseCargo","verdeOficial","baseBlanco","granoEntero",
        "quebrado","yeso","rojo","mancha");

        for($i = 0; $i < count($keys); $i++){
            $ave = $this->parametrosRepository->aveName($filtros,$keys[$i]);
            $parametrosTotales[$keys[$i]] = $ave;
            if($formated === true){
                $parametrosTotales[$keys[$i]] =  number_format($parametrosTotales[$keys[$i]], 2, '.', ',');;
            }
        }
        return $parametrosTotales;
    }

    /**
     * @param $chacra
     * @param entity\Tolerancia $tolerancia
     * @param entity\Base $base
     * @param entity\Parametros $p
     * @return float|int
     */

    public function cantidadBasura($chacra, entity\Tolerancia $tolerancia, entity\Base $base, entity\Parametros $p){
        // --- INICIO BASURA PROCEDIMIENTO -------
        //-- Por arriba de la tolerancia
        // % total de deduccion por basura
        $basuraPorcDeduccion = 0;
        // cantidad de kilos a restar por basura
        $basuraCantDeduccion = 0;
        // % de basura encontrado en el lab
        $basuraPorc = $p->getBasura();
        // % en que se excede a la tolerancia permitida
        $basuraToleranciaPorc = $basuraPorc - $tolerancia->getBasura();
        if($basuraToleranciaPorc > 0){
            // actualizar el % de basura a analizar quitando el exceso sobre la tolerancia
            // ya analizado
            $basuraPorc -= $basuraToleranciaPorc;
            // determinar el prociento de deduccion sobre la tolerancia, aplicando la regla x2
            $basuraPorcDeduccion = $basuraToleranciaPorc * 2;
        }
        // -- Por arriba de la base
        // % de basura por arriba de la base y hasta la tolerancia
        $basuraBasePorc = $basuraPorc - $base->getBasura();
        if($basuraBasePorc > 0){
            // actualizar el % total de deduccion con el exceso sobre la base
            $basuraPorcDeduccion = $basuraPorcDeduccion + $basuraBasePorc;
        }

        if($basuraPorcDeduccion > 0){
            // actualizar la cantidad de arroz a deducir en base al % de deduccion total
            $basuraCantDeduccion = (-1)*($chacra * $basuraPorcDeduccion / 100);
        }
        return $basuraCantDeduccion;
        // --- FIN BASURA PROCEDIMIENTO -------


    }


    /**
     * @param $chacra
     * @param entity\Tolerancia $tolerancia
     * @param entity\Base $base
     * @param entity\Parametros $p
     * @return float|int
     */

    public function cantidadRojo($chacra, entity\Tolerancia $tolerancia, entity\Base $base, entity\Parametros $p){
        // --- INICIO PARAMETRO: GRANOS ROJOS PROCEDIMIENTO -------
        //-- Por arriba de la tolerancia
        // % total de deduccion por PARAMETRO
        $rojoPorcDeduccion = 0;
        // cantidad de kilos a restar por PARAMETRO
        $rojoCantDeduccion = 0;
        // % de PARAMETRO encontrado en el lab
        $rojoPorc = $p->getRojo();
        // % en que se excede a la tolerancia permitida
        $rojoToleranciaPorc = $rojoPorc - $tolerancia->getRojo();
        if($rojoToleranciaPorc > 0){
            // actualizar el % de PARAMETRO a analizar quitando el exceso
            // sobre la tolerancia ya analizado
            $rojoPorc -= $rojoToleranciaPorc;
            // determinar el prociento de deduccion sobre la tolerancia,
            //aplicando la regla x2
            $rojoPorcDeduccion = $rojoToleranciaPorc * 0.5;
        }
        // -- Por arriba de la base
        // % de PARAMETRO por arriba de la base y hasta la tolerancia
        $rojoBasePorc = $rojoPorc - $base->getRojo();
        if($rojoBasePorc > 0){
            // actualizar el % total de deduccion con el exceso sobre la base
            $rojoPorcDeduccion += $rojoBasePorc * 0.25;
        }

        if($rojoPorcDeduccion > 0){
            // actualizar la cantidad de arroz a deducir en base al % de deduccion total
            $rojoCantDeduccion = ($chacra * $rojoPorcDeduccion / 100);
        }
        // --- FIN ROJO PROCEDIMIENTO -------
        return $rojoCantDeduccion;

    }

    /**
     * @param $chacra
     * @param entity\Tolerancia $tolerancia
     * @param entity\Base $base
     * @param entity\Parametros $p
     * @return float|int
     */


    public function cantidadYeso($chacra, entity\Tolerancia $tolerancia, entity\Base $base, entity\Parametros $p){
        // --- INICIO PARAMETRO: GRANOS YESADOS PROCEDIMIENTO -------
        //-- Por arriba de la tolerancia
        // % total de deduccion por PARAMETRO
        $yesoPorcDeduccion = 0;
        // cantidad de kilos a restar por PARAMETRO
        $yesoCantDeduccion = 0;
        // % de PARAMETRO encontrado en el lab
        $yesoPorc = $p->getYeso();
        // % en que se excede a la tolerancia permitida
        $yesoToleranciaPorc = $yesoPorc - $tolerancia->getYeso();
        if($yesoToleranciaPorc > 0){
            // actualizar el % de PARAMETRO a analizar quitando el exceso
            // sobre la tolerancia ya analizado
            $yesoPorc -= $yesoToleranciaPorc;
            // determinar el prociento de deduccion sobre la tolerancia,
            //aplicando la regla x2
            $yesoPorcDeduccion = $yesoToleranciaPorc;
        }
        // -- Por arriba de la base
        // % de PARAMETRO por arriba de la base y hasta la tolerancia
        $yesoBasePorc = $yesoPorc - $base->getYeso();
        if($yesoBasePorc > 0){
            // actualizar el % total de deduccion con el exceso sobre la base
            $yesoPorcDeduccion += $yesoBasePorc * 0.5;
        }

        if($yesoPorcDeduccion > 0){
            // actualizar la cantidad de arroz a deducir en base al % de deduccion total
            $yesoCantDeduccion = ($chacra * $yesoPorcDeduccion / 100);
        }
        // --- FIN yeso PROCEDIMIENTO -------
        return $yesoCantDeduccion;

    }

    /**
     * Un valor negativo hay que penalizar, un valor positibo hay que bonificar
     * @param $chacra
     * @param entity\Base $base
     * @param entity\Parametros $p
     * @return float|int
     */
    public function cantidadBlanco($chacra, entity\Base $base, entity\Parametros $p){
        //-- Por arriba de la tolerancia
        // % total de deduccion por PARAMETRO
        $porcDeduccion = 0;
        // cantidad de kilos a restar por PARAMETRO
        $cantDeduccion = 0;
        // % de PARAMETRO encontrado en el lab
        $porciento = $p->getBaseBlanco();
        // -- Por arriba de la base
        // % de PARAMETRO por arriba de la base
        $basePorc = $porciento - $base->getBaseBlanco();

            // actualizar el % total de deduccion con el exceso sobre la base
        $porcDeduccion = $basePorc * 0.5;


        if($porcDeduccion != 0){
            // actualizar la cantidad de arroz a deducir en base al % de deduccion total
            $cantDeduccion = $chacra * $porcDeduccion / 100;
        }
        // --- FIN yeso PROCEDIMIENTO -------
        return $cantDeduccion;

    }

    /**
     * @param $chacra
     * @param entity\Base $base
     * @param entity\Parametros $p
     * @return int
     */

    public function cantidadHumedad($chacra, entity\Base $base, entity\Parametros $p){
        //-- Por arriba de la tolerancia
        // % total de deduccion por PARAMETRO
        $porciento = 0;
        // cantidad de kilos a restar por PARAMETRO
        $cantDeduccion = 0;
        // % de PARAMETRO encontrado en el lab
        $porciento = $p->getHumedad();
        // -- Por arriba de la base
        // % de PARAMETRO por arriba de la base

        if ($porciento > $base->getHumedad()){
        // actualizar el % total de deduccion con el exceso sobre la base
        //$cantDeduccion = (-1)*((1-((100-$porciento)/87))*$chacra/100);
            $cantDeduccion = -1*($chacra - ( $chacra * ((100-$porciento)/87)));
        }

        // --- FIN yeso PROCEDIMIENTO -------
        return $cantDeduccion;
    }


    /**
     * Un valor negativo hay que penalizar, un valor positibo hay que bonificar
     * @param $chacra
     * @param entity\Base $base
     * @param entity\Parametros $p
     * @return float|int
     */
    public function cantidadEntero($chacra, entity\Base $base, entity\Parametros $p){
        //-- Por arriba de la tolerancia
        // % total de deduccion por PARAMETRO
        $porcDeduccion = 0;
        // cantidad de kilos a restar por PARAMETRO
        $cantDeduccion = 0;
        // % de PARAMETRO encontrado en el lab
        $porciento = $p->getGranoEntero();
        // -- Por arriba de la base
        // % de PARAMETRO por arriba de la base
        $bge = $this->baseGranoEnteroVariedadRepository->findOneBy(array("variedad"=>$p->getVariedad()->getId(),"base"=>$base->getId()));
        $basePorc = $porciento - $bge->getValor();

        // actualizar el % total de deduccion con el exceso sobre la base
        $porcDeduccion = $basePorc * 0.5;


        if($porcDeduccion != 0){
            // actualizar la cantidad de arroz a deducir en base al % de deduccion total
            $cantDeduccion = $chacra * $porcDeduccion / 100;
        }
        // --- FIN yeso PROCEDIMIENTO -------
        return $cantDeduccion;

    }

    /**
     * @param $chacra
     * @param entity\Tolerancia $tolerancia
     * @param entity\Base $base
     * @param entity\Parametros $p
     * @return float|int
     */

    public function cantidadVerde($chacra, entity\Tolerancia $tolerancia, entity\Base $base, entity\Parametros $p){
        // --- INICIO  PROCEDIMIENTO -------
        //-- Por arriba de la tolerancia
        // % total de deduccion por
        $PorcDeduccion = 0;
        // cantidad de kilos a restar por
        $CantDeduccion = 0;
        // % de verde encontrado en el lab
        $porcientoVP = $p->getVerdePrimario();
        $porcientoVO = $p->getVerdeOficial();
        $porciento = 0;
        // % en que se excede a la tolerancia permitida
        if ($porcientoVP > $porcientoVO)
            $porciento = $porcientoVP;
        else
            $porciento = $porcientoVO;

        $ToleranciaPorc = $porciento - $tolerancia->getVerde();
        if($ToleranciaPorc > 0){
            // actualizar el % de  a analizar quitando el exceso sobre la tolerancia
            // ya analizado
            $porciento -= $ToleranciaPorc;
            // determinar el prociento de deduccion sobre la tolerancia, aplicando la regla x2
            $PorcDeduccion = $ToleranciaPorc;
        }
        // -- Por arriba de la base
        // % de  por arriba de la base y hasta la tolerancia
        $BasePorc = $porciento - $base->getVerde();
        if($BasePorc > 0){
            // actualizar el % total de deduccion con el exceso sobre la base
            $PorcDeduccion += $BasePorc * 0.5;
        }

        if($PorcDeduccion > 0){
            // actualizar la cantidad de arroz a deducir en base al % de deduccion total
            $CantDeduccion = -1*($chacra * $PorcDeduccion / 100);
        }
        return $CantDeduccion;
    }

    /**
     * @param $chacra
     * @param entity\Tolerancia $tolerancia
     * @param entity\Base $base
     * @param entity\Parametros $p
     * @return int
     */


    public function cantidadManchados($chacra, entity\Tolerancia $tolerancia, entity\Base $base, entity\Parametros $p){
        // --- INICIO  PROCEDIMIENTO -------
        //-- Por arriba de la tolerancia
        // % total de deduccion por
        $PorcDeduccion = 0;
        // cantidad de kilos a restar por
        $CantDeduccion = 0;
        // % de verde encontrado en el lab
        $porciento = $p->getMancha();
        // % en que se excede a la tolerancia permitida
        $ToleranciaPorc = $porciento - $tolerancia->getMancha();
        if($ToleranciaPorc > 0){
            // actualizar el % de  a analizar quitando el exceso sobre la tolerancia
            // ya analizado
            $porciento -= $ToleranciaPorc;
            // determinar el prociento de deduccion sobre la tolerancia, aplicando la regla x2
            $PorcDeduccion = $ToleranciaPorc * 6;
        }
        // -- Por arriba de la base
        // % de  por arriba de la base y hasta la tolerancia
        $BasePorc = $porciento - $base->getMancha();
        if($BasePorc > 0){
            // actualizar el % total de deduccion con el exceso sobre la base
            $PorcDeduccion += $BasePorc * 3;
        }

        if($PorcDeduccion > 0){
            // actualizar la cantidad de arroz a deducir en base al % de deduccion total
            $CantDeduccion = ($chacra * $PorcDeduccion / 100);
        }
        return $CantDeduccion;
        // --- FIN  PROCEDIMIENTO -------


    }

    /**
     * @param $chacra
     * @param entity\Base $base
     * @return int
     */

    public function cantidadServicioSecado($chacra, entity\Base $base){
        $porciento = $base->getServicioSecado();
        $cantServicioSecado = -1*($chacra * $porciento / 100);
        return $cantServicioSecado;
    }


    /**
     * @param entity\Registro $registro
     */

    public function actualizarResultados(entity\Registro $registro){

        /**
         * @var entity\Resultados $r
         */
        $r = $this->resultadosRepository->findOneById($registro->getId());
        if(!$r){
            $r = new entity\Resultados();
            $r->setId($registro->getId());
        }
        /**
         * @var entity\Parametros $p
         */
        $p = $this->parametrosRepository->findOneById($registro->getId());
        if(!$p){
            $p = new entity\Parametros();
            $p->setId($registro->getId());
        }
        /**
         * @var entity\Base $base
         */
        $base = $this->baseRepository->findOneByProductor($registro->getProductor()->getId());
        if ($base == null)
            $base = $this->baseRepository->findOneByProductor(null);
        $chacra = ($registro->getPesoEntrada() - $registro->getPesoSalida());


        /**
         * @var entity\Tolerancia $tolerancia
         */
        $tolerancia = $this->toleranciaRepository->findOneByProductor($registro->getProductor()->getId());
        if ($tolerancia == null)
            $tolerancia = $this->toleranciaRepository->findOneByProductor(null);


        $cantidadBasura = $this->cantidadBasura($chacra,$tolerancia,$base,$p);
        $cantidadHumedad = $this->cantidadHumedad($chacra,$base,$p);
        $cantidadBlanco = $this->cantidadBlanco($chacra,$base,$p);
        $cantidadEntero = $this->cantidadEntero($chacra,$base,$p);
        // para el caso de rojo, mancha y yeso
        // solo se aplicara la mayor de las deducciones aplicables en caso de tener
        $cantidadRojo = $this->cantidadRojo($chacra, $tolerancia,$base,$p);
        $cantidadManchados = $this->cantidadManchados($chacra,$tolerancia,$base,$p);
        $cantidadYeso = $this->cantidadYeso($chacra,$tolerancia,$base,$p);
        $cantidadVerdes = $this->cantidadVerde($chacra,$tolerancia,$base, $p);
        if ($cantidadRojo > $cantidadManchados && $cantidadRojo > $cantidadYeso)
            $yesoManchaRojo = $cantidadRojo;
            if ($cantidadManchados > $cantidadRojo && $cantidadManchados > $cantidadYeso)
            $yesoManchaRojo = $cantidadManchados;
                else
                $yesoManchaRojo = $cantidadYeso;

        //incluir cantidad deducible por servicio de secado
        $cantidadServicioSecado = $this->cantidadServicioSecado($chacra,$base);
        // Calculos Finales

        $arrozSL = ($chacra + $cantidadBasura) + $cantidadHumedad;

        $premioCastigo = $cantidadBlanco + $cantidadEntero + $cantidadVerdes + ($yesoManchaRojo*-1);

        $arrozSSL = $arrozSL + $premioCastigo;
        // Arroz a pagar al productor
        $arrozNeto = $arrozSSL + $cantidadServicioSecado;

        $registro->setCerrado(true);
        $r->setCantidadBasura($cantidadBasura);
        $r->setCantidadHumedad($cantidadHumedad);
        $r->setCantidadBlanco($cantidadBlanco);
        $r->setCantidadEntero($cantidadEntero);
        $r->setCantidadRojo($cantidadRojo);
        $r->setCantidadManchados($cantidadManchados);
        $r->setCantidadYeso($cantidadYeso);
        $r->setCantidadVerde($cantidadVerdes);
        $r->setServicioSecado($cantidadServicioSecado);
        $r->setArrozChacra($chacra);
        $r->setArrozSL($arrozSL);
        $r->setArrozSSL($arrozSSL);
        $r->setPremioCastigo($premioCastigo);
        $r->setArrozNeto($arrozNeto);
        $this->save($r,false);
        $this->save($registro,true);

    }

    public function actualizarChacraResultados($registro){
        /**
         * @var entity\Resultados $r
         */
        $r = $this->resultadosRepository->findOneById($registro->getId());
        $chacra = ($registro->getPesoEntrada() - $registro->getPesoSalida());
        $r->setArrozChacra($chacra);
        $this->save($r,true);
    }

    /**
     * @return entity\Tolerancia|null
     */
    public function toleranciaProductor($productor = null){
        return $this->toleranciaRepository->findOneBy(array("productor"=>$productor));
    }

    /**
     * @return entity\Base|null
     */
    public function baseProductor($productor = null){
        return $this->baseRepository->findOneBy(array("productor"=>$productor));
    }

    /**
     * @param $p
     * @return \Doctrine\ORM\QueryBuilder
     */
    public function chacrasPorProductor($p){
        return $this->chacraRepository->porProductorQuery($p);
    }

    /**
     * @return entity\Usuario|null
     */
    public function buscarUsuario($tipo,$ref){
        return $this->usuarioRepository->findOneBy(array("tipo"=>$tipo,"referencia"=>$ref));
    }

    public function plantasSegunIp($ip){
        return $this->plantaRepository->porIp($ip);
    }

    /**
     * @return array
     */
    public function listarRoles(){
        return $this->rolRepository->listar();
    }

} 